<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBPrepare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrepareLoanForResubmission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBPrepareLoanForResubmission $parameters
     * @return \LendingQB\StructType\LendingQBPrepareLoanForResubmissionResponse|bool
     */
    public function PrepareLoanForResubmission(\LendingQB\StructType\LendingQBPrepareLoanForResubmission $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrepareLoanForResubmission($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBPrepareLoanForResubmissionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
