<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parse ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBParse extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ParseFnma32ToLoXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBParseFnma32ToLoXml $parameters
     * @return \LendingQB\StructType\LendingQBParseFnma32ToLoXmlResponse|bool
     */
    public function ParseFnma32ToLoXml(\LendingQB\StructType\LendingQBParseFnma32ToLoXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ParseFnma32ToLoXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBParseFnma32ToLoXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
