<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lock ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBLock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LockLoanProgramWithRateOptionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionId $parameters
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdResponse|bool
     */
    public function LockLoanProgramWithRateOptionId(\LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LockLoanProgramWithRateOptionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LockLoanProgram
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLockLoanProgram $parameters
     * @return \LendingQB\StructType\LendingQBLockLoanProgramResponse|bool
     */
    public function LockLoanProgram(\LendingQB\StructType\LendingQBLockLoanProgram $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LockLoanProgram($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * LockLoanProgramAndSkipDuplicateCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLockLoanProgramAndSkipDuplicateCheck $parameters
     * @return \LendingQB\StructType\LendingQBLockLoanProgramAndSkipDuplicateCheckResponse|bool
     */
    public function LockLoanProgramAndSkipDuplicateCheck(\LendingQB\StructType\LendingQBLockLoanProgramAndSkipDuplicateCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LockLoanProgramAndSkipDuplicateCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck $parameters
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheckResponse|bool
     */
    public function LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck(\LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LockLoanProgramWithOptions
     * Meta information extracted from the WSDL
     * - documentation: Locks a loan program. Options can be passed in using an LOXmlFormat payload.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBLockLoanProgramWithOptions $parameters
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithOptionsResponse|bool
     */
    public function LockLoanProgramWithOptions(\LendingQB\StructType\LendingQBLockLoanProgramWithOptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LockLoanProgramWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBLockLoanProgramAndSkipDuplicateCheckResponse|\LendingQB\StructType\LendingQBLockLoanProgramResponse|\LendingQB\StructType\LendingQBLockLoanProgramWithOptionsResponse|\LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheckResponse|\LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
