<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBList extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListEdocsByLoanNumber
     * Meta information extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListEdocsByLoanNumber $parameters
     * @return \LendingQB\StructType\LendingQBListEdocsByLoanNumberResponse|bool
     */
    public function ListEdocsByLoanNumber(\LendingQB\StructType\LendingQBListEdocsByLoanNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListEdocsByLoanNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListClosingCostTemplateName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListClosingCostTemplateName $parameters
     * @return \LendingQB\StructType\LendingQBListClosingCostTemplateNameResponse|bool
     */
    public function ListClosingCostTemplateName(\LendingQB\StructType\LendingQBListClosingCostTemplateName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListClosingCostTemplateName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListModifiedLoans
     * Meta information extracted from the WSDL
     * - documentation: [OBSOLETE] Use ListModifiedLoansByAppCode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListModifiedLoans $parameters
     * @return \LendingQB\StructType\LendingQBListModifiedLoansResponse|bool
     */
    public function ListModifiedLoans(\LendingQB\StructType\LendingQBListModifiedLoans $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListModifiedLoans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListModifiedLoansByAppCode
     * Meta information extracted from the WSDL
     * - documentation: Returns an XML string containing a list of recently modified loans. This method is used if the client wants to poll the LO/PML system on a fixed interval (try to keep this interval big) for recently modified files so that they can be
     * imported into a 3rd-party LOS. Contact support for valid appCode. THIS METHOD ONLY RETURN LOANS MODIFIED IN LAST 90 DAYS.The tracking of modified loan is not enabled by default. To have it enabled you need to contact our integration team, and they
     * will turn on the tracking feature.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListModifiedLoansByAppCode $parameters
     * @return \LendingQB\StructType\LendingQBListModifiedLoansByAppCodeResponse|bool
     */
    public function ListModifiedLoansByAppCode(\LendingQB\StructType\LendingQBListModifiedLoansByAppCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListModifiedLoansByAppCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListModifiedEDocsByAppCode
     * Meta information extracted from the WSDL
     * - documentation: [DEPRECATED] Please use the EDocsService version of this method instead. Returns an XML string containing a list of recently modified eDocs. This method is used if the client wants to poll the LO/PML system on a fixed interval (try
     * to keep this interval big) for recently modified files so that they can be imported into a 3rd-party LOS. Contact support for valid appCode. THIS METHOD ONLY RETURN EDOCS MODIFIED SINCE THE LAST MODIFIED DATE.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListModifiedEDocsByAppCode $parameters
     * @return \LendingQB\StructType\LendingQBListModifiedEDocsByAppCodeResponse|bool
     */
    public function ListModifiedEDocsByAppCode(\LendingQB\StructType\LendingQBListModifiedEDocsByAppCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListModifiedEDocsByAppCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListMyActiveTaskList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBListMyActiveTaskList $parameters
     * @return \LendingQB\StructType\LendingQBListMyActiveTaskListResponse|bool
     */
    public function ListMyActiveTaskList(\LendingQB\StructType\LendingQBListMyActiveTaskList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListMyActiveTaskList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBListClosingCostTemplateNameResponse|\LendingQB\StructType\LendingQBListEdocsByLoanNumberResponse|\LendingQB\StructType\LendingQBListModifiedEDocsByAppCodeResponse|\LendingQB\StructType\LendingQBListModifiedLoansByAppCodeResponse|\LendingQB\StructType\LendingQBListModifiedLoansResponse|\LendingQB\StructType\LendingQBListMyActiveTaskListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
