<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBImport extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportFromFreddieMac
     * Meta information extracted from the WSDL
     * - documentation: Import loan file data from Freddie Mac into an existing or new loan.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBImportFromFreddieMac $parameters
     * @return \LendingQB\StructType\LendingQBImportFromFreddieMacResponse|bool
     */
    public function ImportFromFreddieMac(\LendingQB\StructType\LendingQBImportFromFreddieMac $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportFromFreddieMac($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ImportFromFannieMaeWithInstitutionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBImportFromFannieMaeWithInstitutionId $parameters
     * @return \LendingQB\StructType\LendingQBImportFromFannieMaeWithInstitutionIdResponse|bool
     */
    public function ImportFromFannieMaeWithInstitutionId(\LendingQB\StructType\LendingQBImportFromFannieMaeWithInstitutionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportFromFannieMaeWithInstitutionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportFromFannieMae
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBImportFromFannieMae $parameters
     * @return \LendingQB\StructType\LendingQBImportFromFannieMaeResponse|bool
     */
    public function ImportFromFannieMae(\LendingQB\StructType\LendingQBImportFromFannieMae $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportFromFannieMae($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBImportFromFannieMaeResponse|\LendingQB\StructType\LendingQBImportFromFannieMaeWithInstitutionIdResponse|\LendingQB\StructType\LendingQBImportFromFreddieMacResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
