<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBGenerate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * GenerateClosestCounselingOrganization
     * Meta information extracted from the WSDL
     * - documentation: Generates the 10 closest counseling orgniazations and populates them to the loan.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGenerateClosestCounselingOrganization $parameters
     * @return \LendingQB\StructType\LendingQBGenerateClosestCounselingOrganizationResponse|bool
     */
    public function GenerateClosestCounselingOrganization(\LendingQB\StructType\LendingQBGenerateClosestCounselingOrganization $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateClosestCounselingOrganization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBGenerateClosestCounselingOrganizationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
