<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadLONXmlResponse StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadLONXmlResponse extends AbstractStructBase
{
    /**
     * The UploadLONXmlResult
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $UploadLONXmlResult;
    /**
     * Constructor method for UploadLONXmlResponse
     * @uses LendingQBUploadLONXmlResponse::setUploadLONXmlResult()
     * @param string $uploadLONXmlResult
     */
    public function __construct($uploadLONXmlResult = null)
    {
        $this
            ->setUploadLONXmlResult($uploadLONXmlResult);
    }
    /**
     * Get UploadLONXmlResult value
     * @return string
     */
    public function getUploadLONXmlResult()
    {
        return $this->UploadLONXmlResult;
    }
    /**
     * Set UploadLONXmlResult value
     * @param string $uploadLONXmlResult
     * @return \LendingQB\StructType\LendingQBUploadLONXmlResponse
     */
    public function setUploadLONXmlResult($uploadLONXmlResult = null)
    {
        // validation for constraint: string
        if (!is_null($uploadLONXmlResult) && !is_string($uploadLONXmlResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadLONXmlResult, true), gettype($uploadLONXmlResult)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($uploadLONXmlResult) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $uploadLONXmlResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($uploadLONXmlResult, true)), __LINE__);
        }
        $this->UploadLONXmlResult = $uploadLONXmlResult;
        return $this;
    }
}
