<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadConsumerDocumentRequestDocument StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBUploadConsumerDocumentRequestDocument extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requestId;
    /**
     * The sBase64Pdf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sBase64Pdf;
    /**
     * The pdfDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pdfDescription;
    /**
     * Constructor method for UploadConsumerDocumentRequestDocument
     * @uses LendingQBUploadConsumerDocumentRequestDocument::setAuthTicket()
     * @uses LendingQBUploadConsumerDocumentRequestDocument::setRequestId()
     * @uses LendingQBUploadConsumerDocumentRequestDocument::setSBase64Pdf()
     * @uses LendingQBUploadConsumerDocumentRequestDocument::setPdfDescription()
     * @param string $authTicket
     * @param string $requestId
     * @param string $sBase64Pdf
     * @param string $pdfDescription
     */
    public function __construct($authTicket = null, $requestId = null, $sBase64Pdf = null, $pdfDescription = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setRequestId($requestId)
            ->setSBase64Pdf($sBase64Pdf)
            ->setPdfDescription($pdfDescription);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocument
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocument
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get sBase64Pdf value
     * @return string|null
     */
    public function getSBase64Pdf()
    {
        return $this->sBase64Pdf;
    }
    /**
     * Set sBase64Pdf value
     * @param string $sBase64Pdf
     * @return \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocument
     */
    public function setSBase64Pdf($sBase64Pdf = null)
    {
        // validation for constraint: string
        if (!is_null($sBase64Pdf) && !is_string($sBase64Pdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sBase64Pdf, true), gettype($sBase64Pdf)), __LINE__);
        }
        $this->sBase64Pdf = $sBase64Pdf;
        return $this;
    }
    /**
     * Get pdfDescription value
     * @return string|null
     */
    public function getPdfDescription()
    {
        return $this->pdfDescription;
    }
    /**
     * Set pdfDescription value
     * @param string $pdfDescription
     * @return \LendingQB\StructType\LendingQBUploadConsumerDocumentRequestDocument
     */
    public function setPdfDescription($pdfDescription = null)
    {
        // validation for constraint: string
        if (!is_null($pdfDescription) && !is_string($pdfDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfDescription, true), gettype($pdfDescription)), __LINE__);
        }
        $this->pdfDescription = $pdfDescription;
        return $this;
    }
}
