<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveMismo23Response StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBSaveMismo23Response extends AbstractStructBase
{
    /**
     * The SaveMismo23Result
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $SaveMismo23Result;
    /**
     * Constructor method for SaveMismo23Response
     * @uses LendingQBSaveMismo23Response::setSaveMismo23Result()
     * @param string $saveMismo23Result
     */
    public function __construct($saveMismo23Result = null)
    {
        $this
            ->setSaveMismo23Result($saveMismo23Result);
    }
    /**
     * Get SaveMismo23Result value
     * @return string
     */
    public function getSaveMismo23Result()
    {
        return $this->SaveMismo23Result;
    }
    /**
     * Set SaveMismo23Result value
     * @param string $saveMismo23Result
     * @return \LendingQB\StructType\LendingQBSaveMismo23Response
     */
    public function setSaveMismo23Result($saveMismo23Result = null)
    {
        // validation for constraint: string
        if (!is_null($saveMismo23Result) && !is_string($saveMismo23Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saveMismo23Result, true), gettype($saveMismo23Result)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($saveMismo23Result) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $saveMismo23Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($saveMismo23Result, true)), __LINE__);
        }
        $this->SaveMismo23Result = $saveMismo23Result;
        return $this;
    }
}
