<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveConsumerDocumentRequestDocument StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBRetrieveConsumerDocumentRequestDocument extends AbstractStructBase
{
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $requestId;
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * Constructor method for RetrieveConsumerDocumentRequestDocument
     * @uses LendingQBRetrieveConsumerDocumentRequestDocument::setRequestId()
     * @uses LendingQBRetrieveConsumerDocumentRequestDocument::setAuthTicket()
     * @param int $requestId
     * @param string $authTicket
     */
    public function __construct($requestId = null, $authTicket = null)
    {
        $this
            ->setRequestId($requestId)
            ->setAuthTicket($authTicket);
    }
    /**
     * Get requestId value
     * @return int
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \LendingQB\StructType\LendingQBRetrieveConsumerDocumentRequestDocument
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBRetrieveConsumerDocumentRequestDocument
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
}
