<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecievePdf StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBRecievePdf extends AbstractStructBase
{
    /**
     * The AuthTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthTicket;
    /**
     * The sLNm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The DocumentClassification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentClassification;
    /**
     * The base64PdfContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $base64PdfContent;
    /**
     * Constructor method for RecievePdf
     * @uses LendingQBRecievePdf::setAuthTicket()
     * @uses LendingQBRecievePdf::setSLNm()
     * @uses LendingQBRecievePdf::setDocumentClassification()
     * @uses LendingQBRecievePdf::setBase64PdfContent()
     * @param string $authTicket
     * @param string $sLNm
     * @param string $documentClassification
     * @param string $base64PdfContent
     */
    public function __construct($authTicket = null, $sLNm = null, $documentClassification = null, $base64PdfContent = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setSLNm($sLNm)
            ->setDocumentClassification($documentClassification)
            ->setBase64PdfContent($base64PdfContent);
    }
    /**
     * Get AuthTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->AuthTicket;
    }
    /**
     * Set AuthTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBRecievePdf
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->AuthTicket = $authTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBRecievePdf
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLNm, true), gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get DocumentClassification value
     * @return string|null
     */
    public function getDocumentClassification()
    {
        return $this->DocumentClassification;
    }
    /**
     * Set DocumentClassification value
     * @param string $documentClassification
     * @return \LendingQB\StructType\LendingQBRecievePdf
     */
    public function setDocumentClassification($documentClassification = null)
    {
        // validation for constraint: string
        if (!is_null($documentClassification) && !is_string($documentClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentClassification, true), gettype($documentClassification)), __LINE__);
        }
        $this->DocumentClassification = $documentClassification;
        return $this;
    }
    /**
     * Get base64PdfContent value
     * @return string|null
     */
    public function getBase64PdfContent()
    {
        return $this->base64PdfContent;
    }
    /**
     * Set base64PdfContent value
     * @param string $base64PdfContent
     * @return \LendingQB\StructType\LendingQBRecievePdf
     */
    public function setBase64PdfContent($base64PdfContent = null)
    {
        // validation for constraint: string
        if (!is_null($base64PdfContent) && !is_string($base64PdfContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64PdfContent, true), gettype($base64PdfContent)), __LINE__);
        }
        $this->base64PdfContent = $base64PdfContent;
        return $this;
    }
}
