<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
 * StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck extends AbstractStructBase
{
    /**
     * The requestedRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedRate;
    /**
     * The requestedFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $requestedFee;
    /**
     * The skipDuplicateCheck
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $skipDuplicateCheck;
    /**
     * The sTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * The sLNm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sLNm;
    /**
     * The lLpTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lLpTemplateId;
    /**
     * The rateOptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rateOptionId;
    /**
     * Constructor method for LockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setRequestedRate()
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setRequestedFee()
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setSkipDuplicateCheck()
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setSTicket()
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setSLNm()
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setLLpTemplateId()
     * @uses LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck::setRateOptionId()
     * @param float $requestedRate
     * @param float $requestedFee
     * @param bool $skipDuplicateCheck
     * @param string $sTicket
     * @param string $sLNm
     * @param string $lLpTemplateId
     * @param string $rateOptionId
     */
    public function __construct($requestedRate = null, $requestedFee = null, $skipDuplicateCheck = null, $sTicket = null, $sLNm = null, $lLpTemplateId = null, $rateOptionId = null)
    {
        $this
            ->setRequestedRate($requestedRate)
            ->setRequestedFee($requestedFee)
            ->setSkipDuplicateCheck($skipDuplicateCheck)
            ->setSTicket($sTicket)
            ->setSLNm($sLNm)
            ->setLLpTemplateId($lLpTemplateId)
            ->setRateOptionId($rateOptionId);
    }
    /**
     * Get requestedRate value
     * @return float
     */
    public function getRequestedRate()
    {
        return $this->requestedRate;
    }
    /**
     * Set requestedRate value
     * @param float $requestedRate
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setRequestedRate($requestedRate = null)
    {
        // validation for constraint: float
        if (!is_null($requestedRate) && !(is_float($requestedRate) || is_numeric($requestedRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedRate, true), gettype($requestedRate)), __LINE__);
        }
        $this->requestedRate = $requestedRate;
        return $this;
    }
    /**
     * Get requestedFee value
     * @return float
     */
    public function getRequestedFee()
    {
        return $this->requestedFee;
    }
    /**
     * Set requestedFee value
     * @param float $requestedFee
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setRequestedFee($requestedFee = null)
    {
        // validation for constraint: float
        if (!is_null($requestedFee) && !(is_float($requestedFee) || is_numeric($requestedFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($requestedFee, true), gettype($requestedFee)), __LINE__);
        }
        $this->requestedFee = $requestedFee;
        return $this;
    }
    /**
     * Get skipDuplicateCheck value
     * @return bool
     */
    public function getSkipDuplicateCheck()
    {
        return $this->skipDuplicateCheck;
    }
    /**
     * Set skipDuplicateCheck value
     * @param bool $skipDuplicateCheck
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setSkipDuplicateCheck($skipDuplicateCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipDuplicateCheck) && !is_bool($skipDuplicateCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipDuplicateCheck, true), gettype($skipDuplicateCheck)), __LINE__);
        }
        $this->skipDuplicateCheck = $skipDuplicateCheck;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTicket, true), gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
    /**
     * Get sLNm value
     * @return string|null
     */
    public function getSLNm()
    {
        return $this->sLNm;
    }
    /**
     * Set sLNm value
     * @param string $sLNm
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setSLNm($sLNm = null)
    {
        // validation for constraint: string
        if (!is_null($sLNm) && !is_string($sLNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sLNm, true), gettype($sLNm)), __LINE__);
        }
        $this->sLNm = $sLNm;
        return $this;
    }
    /**
     * Get lLpTemplateId value
     * @return string|null
     */
    public function getLLpTemplateId()
    {
        return $this->lLpTemplateId;
    }
    /**
     * Set lLpTemplateId value
     * @param string $lLpTemplateId
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setLLpTemplateId($lLpTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($lLpTemplateId) && !is_string($lLpTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lLpTemplateId, true), gettype($lLpTemplateId)), __LINE__);
        }
        $this->lLpTemplateId = $lLpTemplateId;
        return $this;
    }
    /**
     * Get rateOptionId value
     * @return string|null
     */
    public function getRateOptionId()
    {
        return $this->rateOptionId;
    }
    /**
     * Set rateOptionId value
     * @param string $rateOptionId
     * @return \LendingQB\StructType\LendingQBLockLoanProgramWithRateOptionIdAndSkipDuplicateCheck
     */
    public function setRateOptionId($rateOptionId = null)
    {
        // validation for constraint: string
        if (!is_null($rateOptionId) && !is_string($rateOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateOptionId, true), gettype($rateOptionId)), __LINE__);
        }
        $this->rateOptionId = $rateOptionId;
        return $this;
    }
}
