<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAuditLog StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBGetAuditLog extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanNumber;
    /**
     * Constructor method for GetAuditLog
     * @uses LendingQBGetAuditLog::setAuthTicket()
     * @uses LendingQBGetAuditLog::setLoanNumber()
     * @param string $authTicket
     * @param string $loanNumber
     */
    public function __construct($authTicket = null, $loanNumber = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setLoanNumber($loanNumber);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBGetAuditLog
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanNumber value
     * @return string|null
     */
    public function getLoanNumber()
    {
        return $this->loanNumber;
    }
    /**
     * Set loanNumber value
     * @param string $loanNumber
     * @return \LendingQB\StructType\LendingQBGetAuditLog
     */
    public function setLoanNumber($loanNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loanNumber) && !is_string($loanNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanNumber, true), gettype($loanNumber)), __LINE__);
        }
        $this->loanNumber = $loanNumber;
        return $this;
    }
}
