<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadEdocsPdfById StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBDownloadEdocsPdfById extends AbstractStructBase
{
    /**
     * The docId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $docId;
    /**
     * The sTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sTicket;
    /**
     * Constructor method for DownloadEdocsPdfById
     * @uses LendingQBDownloadEdocsPdfById::setDocId()
     * @uses LendingQBDownloadEdocsPdfById::setSTicket()
     * @param string $docId
     * @param string $sTicket
     */
    public function __construct($docId = null, $sTicket = null)
    {
        $this
            ->setDocId($docId)
            ->setSTicket($sTicket);
    }
    /**
     * Get docId value
     * @return string
     */
    public function getDocId()
    {
        return $this->docId;
    }
    /**
     * Set docId value
     * @param string $docId
     * @return \LendingQB\StructType\LendingQBDownloadEdocsPdfById
     */
    public function setDocId($docId = null)
    {
        // validation for constraint: string
        if (!is_null($docId) && !is_string($docId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docId, true), gettype($docId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($docId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $docId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($docId, true)), __LINE__);
        }
        $this->docId = $docId;
        return $this;
    }
    /**
     * Get sTicket value
     * @return string|null
     */
    public function getSTicket()
    {
        return $this->sTicket;
    }
    /**
     * Set sTicket value
     * @param string $sTicket
     * @return \LendingQB\StructType\LendingQBDownloadEdocsPdfById
     */
    public function setSTicket($sTicket = null)
    {
        // validation for constraint: string
        if (!is_null($sTicket) && !is_string($sTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTicket, true), gettype($sTicket)), __LINE__);
        }
        $this->sTicket = $sTicket;
        return $this;
    }
}
