<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateClosingDisclosureArchiveByReferenceNumber StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBCreateClosingDisclosureArchiveByReferenceNumber extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanRefNumber;
    /**
     * The dataXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataXml;
    /**
     * The secretKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secretKey;
    /**
     * Constructor method for CreateClosingDisclosureArchiveByReferenceNumber
     * @uses LendingQBCreateClosingDisclosureArchiveByReferenceNumber::setAuthTicket()
     * @uses LendingQBCreateClosingDisclosureArchiveByReferenceNumber::setLoanRefNumber()
     * @uses LendingQBCreateClosingDisclosureArchiveByReferenceNumber::setDataXml()
     * @uses LendingQBCreateClosingDisclosureArchiveByReferenceNumber::setSecretKey()
     * @param string $authTicket
     * @param string $loanRefNumber
     * @param string $dataXml
     * @param string $secretKey
     */
    public function __construct($authTicket = null, $loanRefNumber = null, $dataXml = null, $secretKey = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setLoanRefNumber($loanRefNumber)
            ->setDataXml($dataXml)
            ->setSecretKey($secretKey);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanRefNumber value
     * @return string|null
     */
    public function getLoanRefNumber()
    {
        return $this->loanRefNumber;
    }
    /**
     * Set loanRefNumber value
     * @param string $loanRefNumber
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber
     */
    public function setLoanRefNumber($loanRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loanRefNumber) && !is_string($loanRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanRefNumber, true), gettype($loanRefNumber)), __LINE__);
        }
        $this->loanRefNumber = $loanRefNumber;
        return $this;
    }
    /**
     * Get dataXml value
     * @return string|null
     */
    public function getDataXml()
    {
        return $this->dataXml;
    }
    /**
     * Set dataXml value
     * @param string $dataXml
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber
     */
    public function setDataXml($dataXml = null)
    {
        // validation for constraint: string
        if (!is_null($dataXml) && !is_string($dataXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataXml, true), gettype($dataXml)), __LINE__);
        }
        $this->dataXml = $dataXml;
        return $this;
    }
    /**
     * Get secretKey value
     * @return string|null
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }
    /**
     * Set secretKey value
     * @param string $secretKey
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchiveByReferenceNumber
     */
    public function setSecretKey($secretKey = null)
    {
        // validation for constraint: string
        if (!is_null($secretKey) && !is_string($secretKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretKey, true), gettype($secretKey)), __LINE__);
        }
        $this->secretKey = $secretKey;
        return $this;
    }
}
