<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateClosingDisclosureArchive StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBCreateClosingDisclosureArchive extends AbstractStructBase
{
    /**
     * The authTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authTicket;
    /**
     * The loanNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loanNumber;
    /**
     * The dataXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataXml;
    /**
     * The secretKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secretKey;
    /**
     * Constructor method for CreateClosingDisclosureArchive
     * @uses LendingQBCreateClosingDisclosureArchive::setAuthTicket()
     * @uses LendingQBCreateClosingDisclosureArchive::setLoanNumber()
     * @uses LendingQBCreateClosingDisclosureArchive::setDataXml()
     * @uses LendingQBCreateClosingDisclosureArchive::setSecretKey()
     * @param string $authTicket
     * @param string $loanNumber
     * @param string $dataXml
     * @param string $secretKey
     */
    public function __construct($authTicket = null, $loanNumber = null, $dataXml = null, $secretKey = null)
    {
        $this
            ->setAuthTicket($authTicket)
            ->setLoanNumber($loanNumber)
            ->setDataXml($dataXml)
            ->setSecretKey($secretKey);
    }
    /**
     * Get authTicket value
     * @return string|null
     */
    public function getAuthTicket()
    {
        return $this->authTicket;
    }
    /**
     * Set authTicket value
     * @param string $authTicket
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchive
     */
    public function setAuthTicket($authTicket = null)
    {
        // validation for constraint: string
        if (!is_null($authTicket) && !is_string($authTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTicket, true), gettype($authTicket)), __LINE__);
        }
        $this->authTicket = $authTicket;
        return $this;
    }
    /**
     * Get loanNumber value
     * @return string|null
     */
    public function getLoanNumber()
    {
        return $this->loanNumber;
    }
    /**
     * Set loanNumber value
     * @param string $loanNumber
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchive
     */
    public function setLoanNumber($loanNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loanNumber) && !is_string($loanNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanNumber, true), gettype($loanNumber)), __LINE__);
        }
        $this->loanNumber = $loanNumber;
        return $this;
    }
    /**
     * Get dataXml value
     * @return string|null
     */
    public function getDataXml()
    {
        return $this->dataXml;
    }
    /**
     * Set dataXml value
     * @param string $dataXml
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchive
     */
    public function setDataXml($dataXml = null)
    {
        // validation for constraint: string
        if (!is_null($dataXml) && !is_string($dataXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataXml, true), gettype($dataXml)), __LINE__);
        }
        $this->dataXml = $dataXml;
        return $this;
    }
    /**
     * Get secretKey value
     * @return string|null
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }
    /**
     * Set secretKey value
     * @param string $secretKey
     * @return \LendingQB\StructType\LendingQBCreateClosingDisclosureArchive
     */
    public function setSecretKey($secretKey = null)
    {
        // validation for constraint: string
        if (!is_null($secretKey) && !is_string($secretKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretKey, true), gettype($secretKey)), __LINE__);
        }
        $this->secretKey = $secretKey;
        return $this;
    }
}
