<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Submit ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBSubmit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SubmitTotalScorecard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitTotalScorecard $parameters
     * @return \LendingQB\StructType\LendingQBSubmitTotalScorecardResponse|bool
     */
    public function SubmitTotalScorecard(\LendingQB\StructType\LendingQBSubmitTotalScorecard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitTotalScorecard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitToFannieMaeEarlyCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToFannieMaeEarlyCheck $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToFannieMaeEarlyCheckResponse|bool
     */
    public function SubmitToFannieMaeEarlyCheck(\LendingQB\StructType\LendingQBSubmitToFannieMaeEarlyCheck $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToFannieMaeEarlyCheck($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitToDesktopUnderwriterSeamless
     * Meta information extracted from the WSDL
     * - documentation: Performs a seamless submission to Desktop Underwriter. Imports the DU credit report.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessResponse|bool
     */
    public function SubmitToDesktopUnderwriterSeamless(\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopUnderwriterSeamless($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SubmitToDesktopUnderwriterSeamless_OptionalCredit
     * Meta information extracted from the WSDL
     * - documentation: Performs a seamless submission to Desktop Underwriter. Provides an option to not import the credit report.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless_OptionalCredit $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless_OptionalCreditResponse|bool
     */
    public function SubmitToDesktopUnderwriterSeamless_OptionalCredit(\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless_OptionalCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopUnderwriterSeamless_OptionalCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SubmitToDesktopUnderwriterSeamlessReissueCredit
     * Meta information extracted from the WSDL
     * - documentation: Performs a seamless submission to Desktop Underwriter. Credit is re-issued according to the creditXml and imported.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCreditResponse|bool
     */
    public function SubmitToDesktopUnderwriterSeamlessReissueCredit(\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopUnderwriterSeamlessReissueCredit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport
     * Meta information extracted from the WSDL
     * - documentation: Performs a seamless submission to Desktop Underwriter. Credit is re-issued according to the creditXml.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImportResponse|bool
     */
    public function SubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport(\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitToDesktopOriginatorSeamless
     * Meta information extracted from the WSDL
     * - documentation: Performs a seamless submission to Desktop Originator.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopOriginatorSeamless $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopOriginatorSeamlessResponse|bool
     */
    public function SubmitToDesktopOriginatorSeamless(\LendingQB\StructType\LendingQBSubmitToDesktopOriginatorSeamless $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopOriginatorSeamless($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SubmitToDesktopUnderwriterWithInstituteId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterWithInstituteId $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterWithInstituteIdResponse|bool
     */
    public function SubmitToDesktopUnderwriterWithInstituteId(\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterWithInstituteId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopUnderwriterWithInstituteId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitToDesktopUnderwriter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriter $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterResponse|bool
     */
    public function SubmitToDesktopUnderwriter(\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopUnderwriter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubmitToDesktopOriginator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSubmitToDesktopOriginator $parameters
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopOriginatorResponse|bool
     */
    public function SubmitToDesktopOriginator(\LendingQB\StructType\LendingQBSubmitToDesktopOriginator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubmitToDesktopOriginator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBSubmitToDesktopOriginatorResponse|\LendingQB\StructType\LendingQBSubmitToDesktopOriginatorSeamlessResponse|\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterResponse|\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCreditResponse|\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessReissueCredit_OptionalCreditImportResponse|\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamlessResponse|\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterSeamless_OptionalCreditResponse|\LendingQB\StructType\LendingQBSubmitToDesktopUnderwriterWithInstituteIdResponse|\LendingQB\StructType\LendingQBSubmitToFannieMaeEarlyCheckResponse|\LendingQB\StructType\LendingQBSubmitTotalScorecardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
