<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBSave extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Save
     * Meta information extracted from the WSDL
     * - documentation: Update the loan file with new information. [sDataContent] The information to update. Only fields that needs updating should be sent over. [format] Identifies the output format to use. 0 - LO XML Query. <RETURN> - XML result string
     * indicating if the Save operation succeeded or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSave $parameters
     * @return \LendingQB\StructType\LendingQBSaveResponse|bool
     */
    public function Save(\LendingQB\StructType\LendingQBSave $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Save($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveByRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Update the loan file with new information. [sDataContent] The information to update. Only fields that needs updating should be sent over. [format] Identifies the output format to use. 0 - LO XML Query. <RETURN> - XML result string
     * indicating if the Save operation succeeded or not.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSaveByRefNumber $parameters
     * @return \LendingQB\StructType\LendingQBSaveByRefNumberResponse|bool
     */
    public function SaveByRefNumber(\LendingQB\StructType\LendingQBSaveByRefNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveByRefNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMismo23
     * Meta information extracted from the WSDL
     * - documentation: Do not use this method
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBSaveMismo23 $parameters
     * @return \LendingQB\StructType\LendingQBSaveMismo23Response|bool
     */
    public function SaveMismo23(\LendingQB\StructType\LendingQBSaveMismo23 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMismo23($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBSaveByRefNumberResponse|\LendingQB\StructType\LendingQBSaveMismo23Response|\LendingQB\StructType\LendingQBSaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
