<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recieve ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBRecieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecievePdf
     * Meta information extracted from the WSDL
     * - documentation: PDF upload for integrations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBRecievePdf $parameters
     * @return \LendingQB\StructType\LendingQBRecievePdfResponse|bool
     */
    public function RecievePdf(\LendingQB\StructType\LendingQBRecievePdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecievePdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBRecievePdfResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
