<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetPdfByLoanName
     * Meta information extracted from the WSDL
     * - documentation: Retrieve a PDF document for a particular loan file. [Result] - The PDF content in base64 format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetPdfByLoanName $parameters
     * @return \LendingQB\StructType\LendingQBGetPdfByLoanNameResponse|bool
     */
    public function GetPdfByLoanName(\LendingQB\StructType\LendingQBGetPdfByLoanName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPdfByLoanName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetDesktopUnderwriterCasefileStatusByLoanFile
     * Meta information extracted from the WSDL
     * - documentation: This method returns casefile status from DU/DO. isDo determines whether the user credentials are for Desktop Originator. This method obtains CasefileID from the specified loan file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusByLoanFile $parameters
     * @return \LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusByLoanFileResponse|bool
     */
    public function GetDesktopUnderwriterCasefileStatusByLoanFile(\LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusByLoanFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDesktopUnderwriterCasefileStatusByLoanFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetDesktopUnderwriterCasefileStatus
     * Meta information extracted from the WSDL
     * - documentation: This method returns casefile status from DU/DO. isDo determines whether the user credentials are for Desktop Originator.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatus $parameters
     * @return \LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusResponse|bool
     */
    public function GetDesktopUnderwriterCasefileStatus(\LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDesktopUnderwriterCasefileStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAuditLog
     * Meta information extracted from the WSDL
     * - documentation: Retrieves the loan's audit log
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetAuditLog $parameters
     * @return \LendingQB\StructType\LendingQBGetAuditLogResponse|bool
     */
    public function GetAuditLog(\LendingQB\StructType\LendingQBGetAuditLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAuditLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBGetAuditLogResponse|\LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusByLoanFileResponse|\LendingQB\StructType\LendingQBGetDesktopUnderwriterCasefileStatusResponse|\LendingQB\StructType\LendingQBGetPdfByLoanNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
