<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBAdd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddBorrower
     * Meta information extracted from the WSDL
     * - documentation: Adds a borrower. [sTicket] Ticket returned by AuthServices.asmx. [optionsXml] LoXml with loanid / loan reference number / loan number, optional borrowerid, optional uladApplicationId. [returns] xml which can have
     * CreatedLegacyApplicationId, CreatedUladApplicationId, CreatedCoborrowerId, CreatedBorrowerId, LegacyApplicationId, or UladApplicationId elements.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBAddBorrower $parameters
     * @return \LendingQB\StructType\LendingQBAddBorrowerResponse|bool
     */
    public function AddBorrower(\LendingQB\StructType\LendingQBAddBorrower $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddBorrower($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBAddBorrowerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
