<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.lendingqb.com/los/webservice/AuthService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.lendingqb.com/los/webservice/AuthService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LendingQB\LendingQBClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \LendingQB\ServiceType\LendingQBGet($options);
/**
 * Sample call for GetUserAuthTicket operation/method
 */
if ($get->GetUserAuthTicket(new \LendingQB\StructType\LendingQBGetUserAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserAuthTicketAndChangePassword operation/method
 */
if ($get->GetUserAuthTicketAndChangePassword(new \LendingQB\StructType\LendingQBGetUserAuthTicketAndChangePassword()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetActiveDirectoryUserAuthTicket operation/method
 */
if ($get->GetActiveDirectoryUserAuthTicket(new \LendingQB\StructType\LendingQBGetActiveDirectoryUserAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPmlUserAuthTicket operation/method
 */
if ($get->GetPmlUserAuthTicket(new \LendingQB\StructType\LendingQBGetPmlUserAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMobilePmlUserAuthTicket operation/method
 */
if ($get->GetMobilePmlUserAuthTicket(new \LendingQB\StructType\LendingQBGetMobilePmlUserAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBrokerPartnerAuthTicket operation/method
 */
if ($get->GetBrokerPartnerAuthTicket(new \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMobileUserAuthTicket operation/method
 */
if ($get->GetMobileUserAuthTicket(new \LendingQB\StructType\LendingQBGetMobileUserAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMobileADUseAuthTicket operation/method
 */
if ($get->GetMobileADUseAuthTicket(new \LendingQB\StructType\LendingQBGetMobileADUseAuthTicket()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
