<?php

namespace LendingQB\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package LendingQB
 * @subpackage Services
 */
class LendingQBGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetUserAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: Convert a LendingQB user's login and password into an auth-ticket.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetUserAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetUserAuthTicketResponse|bool
     */
    public function GetUserAuthTicket(\LendingQB\StructType\LendingQBGetUserAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserAuthTicketAndChangePassword
     * Meta informations extracted from the WSDL
     * - documentation: Convert a LendingQB user's login and password into an auth-ticket and change the password of the user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetUserAuthTicketAndChangePassword $parameters
     * @return \LendingQB\StructType\LendingQBGetUserAuthTicketAndChangePasswordResponse|bool
     */
    public function GetUserAuthTicketAndChangePassword(\LendingQB\StructType\LendingQBGetUserAuthTicketAndChangePassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserAuthTicketAndChangePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActiveDirectoryUserAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: Authenticate a LendingQB user against an Active Directory database. Returns an auth-ticket. [customerCode] Contact your account administrator to request your company's customer code. This method should only be used to authenticate
     * LendingQB users that have been configured for Active Directory authentication.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetActiveDirectoryUserAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetActiveDirectoryUserAuthTicketResponse|bool
     */
    public function GetActiveDirectoryUserAuthTicket(\LendingQB\StructType\LendingQBGetActiveDirectoryUserAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetActiveDirectoryUserAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPmlUserAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: Convert a PriceMyLoan.com user's login and password into an auth-ticket. [customerCode] Your PML Support Engineer can provide you with your company's customer code if you do not know what it is. The format for this customer code is
     * PML#### (i.e., PML0445)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetPmlUserAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetPmlUserAuthTicketResponse|bool
     */
    public function GetPmlUserAuthTicket(\LendingQB\StructType\LendingQBGetPmlUserAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPmlUserAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMobilePmlUserAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: Convert a PML user's login and password into an auth-ticket for mobile users.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetMobilePmlUserAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetMobilePmlUserAuthTicketResponse|bool
     */
    public function GetMobilePmlUserAuthTicket(\LendingQB\StructType\LendingQBGetMobilePmlUserAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMobilePmlUserAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBrokerPartnerAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: This method is deprecated. Please use GetUserAuthTicket instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicketResponse|bool
     */
    public function GetBrokerPartnerAuthTicket(\LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBrokerPartnerAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMobileUserAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: Convert a LendingQB user's login and password into an auth-ticket wich checking mobile restriction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetMobileUserAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetMobileUserAuthTicketResponse|bool
     */
    public function GetMobileUserAuthTicket(\LendingQB\StructType\LendingQBGetMobileUserAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMobileUserAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMobileADUseAuthTicket
     * Meta informations extracted from the WSDL
     * - documentation: Authenticate a LendingQB user against an Active Directory database with checking mobile restriction.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LendingQB\StructType\LendingQBGetMobileADUseAuthTicket $parameters
     * @return \LendingQB\StructType\LendingQBGetMobileADUseAuthTicketResponse|bool
     */
    public function GetMobileADUseAuthTicket(\LendingQB\StructType\LendingQBGetMobileADUseAuthTicket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMobileADUseAuthTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LendingQB\StructType\LendingQBGetActiveDirectoryUserAuthTicketResponse|\LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicketResponse|\LendingQB\StructType\LendingQBGetMobileADUseAuthTicketResponse|\LendingQB\StructType\LendingQBGetMobilePmlUserAuthTicketResponse|\LendingQB\StructType\LendingQBGetMobileUserAuthTicketResponse|\LendingQB\StructType\LendingQBGetPmlUserAuthTicketResponse|\LendingQB\StructType\LendingQBGetUserAuthTicketAndChangePasswordResponse|\LendingQB\StructType\LendingQBGetUserAuthTicketResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
