<?php

namespace LendingQB\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBrokerPartnerAuthTicket StructType
 * @package LendingQB
 * @subpackage Structs
 */
class LendingQBGetBrokerPartnerAuthTicket extends AbstractStructBase
{
    /**
     * The brokerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $brokerId;
    /**
     * The sSecretKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSecretKey;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * Constructor method for GetBrokerPartnerAuthTicket
     * @uses LendingQBGetBrokerPartnerAuthTicket::setBrokerId()
     * @uses LendingQBGetBrokerPartnerAuthTicket::setSSecretKey()
     * @uses LendingQBGetBrokerPartnerAuthTicket::setUserName()
     * @param string $brokerId
     * @param string $sSecretKey
     * @param string $userName
     */
    public function __construct($brokerId = null, $sSecretKey = null, $userName = null)
    {
        $this
            ->setBrokerId($brokerId)
            ->setSSecretKey($sSecretKey)
            ->setUserName($userName);
    }
    /**
     * Get brokerId value
     * @return string
     */
    public function getBrokerId()
    {
        return $this->brokerId;
    }
    /**
     * Set brokerId value
     * @param string $brokerId
     * @return \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($brokerId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($brokerId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($brokerId) && !is_string($brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerId)), __LINE__);
        }
        $this->brokerId = $brokerId;
        return $this;
    }
    /**
     * Get sSecretKey value
     * @return string|null
     */
    public function getSSecretKey()
    {
        return $this->sSecretKey;
    }
    /**
     * Set sSecretKey value
     * @param string $sSecretKey
     * @return \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket
     */
    public function setSSecretKey($sSecretKey = null)
    {
        // validation for constraint: string
        if (!is_null($sSecretKey) && !is_string($sSecretKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSecretKey)), __LINE__);
        }
        $this->sSecretKey = $sSecretKey;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \LendingQB\StructType\LendingQBGetBrokerPartnerAuthTicket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
