<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws.eye-move.nl/Relatie.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws.eye-move.nl/Relatie.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for Add operation/method
 */
if ($add->Add(new \StructType\Add()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDocumentenChecklist operation/method
 */
if ($add->AddDocumentenChecklist(new \StructType\AddDocumentenChecklist()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for Delete operation/method
 */
if ($delete->Delete(new \StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for Get operation/method
 */
if ($get->Get(new \StructType\Get()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGUID operation/method
 */
if ($get->GetGUID(new \StructType\GetGUID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetByEmailadres operation/method
 */
if ($get->GetByEmailadres(new \StructType\GetByEmailadres()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetByDataDelenGUID operation/method
 */
if ($get->GetByDataDelenGUID(new \StructType\GetByDataDelenGUID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Documenten ServiceType
 */
$documenten = new \ServiceType\Documenten($options);
$documenten->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for DocumentenCompleet operation/method
 */
if ($documenten->DocumentenCompleet(new \StructType\DocumentenCompleet()) !== false) {
    print_r($documenten->getResult());
} else {
    print_r($documenten->getLastError());
}
