<?php

namespace EnumType;

/**
 * This class stands for TypeLegitimatiebewijs EnumType
 * @subpackage Enumerations
 */
class TypeLegitimatiebewijs
{
    /**
     * Constant for value 'IDKaart'
     * @return string 'IDKaart'
     */
    const VALUE_IDKAART = 'IDKaart';
    /**
     * Constant for value 'Paspoort'
     * @return string 'Paspoort'
     */
    const VALUE_PASPOORT = 'Paspoort';
    /**
     * Constant for value 'Rijbewijs'
     * @return string 'Rijbewijs'
     */
    const VALUE_RIJBEWIJS = 'Rijbewijs';
    /**
     * Constant for value 'Verblijfsvergunning'
     * @return string 'Verblijfsvergunning'
     */
    const VALUE_VERBLIJFSVERGUNNING = 'Verblijfsvergunning';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IDKAART
     * @uses self::VALUE_PASPOORT
     * @uses self::VALUE_RIJBEWIJS
     * @uses self::VALUE_VERBLIJFSVERGUNNING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IDKAART,
            self::VALUE_PASPOORT,
            self::VALUE_RIJBEWIJS,
            self::VALUE_VERBLIJFSVERGUNNING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
