<?php

namespace EnumType;

/**
 * This class stands for TypeHuidigeWoning EnumType
 * @subpackage Enumerations
 */
class TypeHuidigeWoning
{
    /**
     * Constant for value 'koopwoning'
     * @return string 'koopwoning'
     */
    const VALUE_KOOPWONING = 'koopwoning';
    /**
     * Constant for value 'huurwoning'
     * @return string 'huurwoning'
     */
    const VALUE_HUURWONING = 'huurwoning';
    /**
     * Constant for value 'inwonend'
     * @return string 'inwonend'
     */
    const VALUE_INWONEND = 'inwonend';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KOOPWONING
     * @uses self::VALUE_HUURWONING
     * @uses self::VALUE_INWONEND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KOOPWONING,
            self::VALUE_HUURWONING,
            self::VALUE_INWONEND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
