<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieGegevens StructType
 * @subpackage Structs
 */
class RelatieGegevens extends AbstractStructBase
{
    /**
     * The BezitEigenWoning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $BezitEigenWoning;
    /**
     * The Geslacht
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Geslacht;
    /**
     * The Huisnummer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Huisnummer;
    /**
     * The Naam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Naam;
    /**
     * The Plaats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Plaats;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The Straatnaam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Straatnaam;
    /**
     * The Voorletters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Voorletters;
    /**
     * The Roepnaam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Roepnaam;
    /**
     * The Voornamen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Voornamen;
    /**
     * The Nationaliteit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Nationaliteit;
    /**
     * The Herkomst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Herkomst;
    /**
     * The PersoonlijkeInformatie
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PersoonlijkeInformatie;
    /**
     * The RecID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $RecID;
    /**
     * The Bedrijfsnaam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bedrijfsnaam;
    /**
     * The BurgerlijkeStaat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BurgerlijkeStaat;
    /**
     * The Geboortedatum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Geboortedatum;
    /**
     * The Geboorteplaats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Geboorteplaats;
    /**
     * The Land
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Land;
    /**
     * The PartnerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PartnerID;
    /**
     * The Toevoeging
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Toevoeging;
    /**
     * The Tussenvoegsel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tussenvoegsel;
    /**
     * The BIC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BIC;
    /**
     * The Rekeningnummer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rekeningnummer;
    /**
     * The Legitimatiebewijs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Legitimatiebewijs;
    /**
     * The NummerLegitimatiebewijs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NummerLegitimatiebewijs;
    /**
     * The DatumUitgifteLegitimatiebewijs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumUitgifteLegitimatiebewijs;
    /**
     * The PlaatsUitgifteLegitimatiebewijs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaatsUitgifteLegitimatiebewijs;
    /**
     * The InkomenPerMaand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InkomenPerMaand;
    /**
     * The MaandelijkseTermijnen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MaandelijkseTermijnen;
    /**
     * The BeschikbaarVermogen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BeschikbaarVermogen;
    /**
     * The AccountmanagerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AccountmanagerID;
    /**
     * The DataDelenGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $DataDelenGUID;
    /**
     * The AantalKinderen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AantalKinderen;
    /**
     * The AantalVolwassenen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AantalVolwassenen;
    /**
     * The GeschatteVerkoopWaarde
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GeschatteVerkoopWaarde;
    /**
     * The HoogteHypotheek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HoogteHypotheek;
    /**
     * The Invoerdatum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Invoerdatum;
    /**
     * The SoortDienstverband
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SoortDienstverband;
    /**
     * The HuidigeWoning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HuidigeWoning;
    /**
     * The Taal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Taal;
    /**
     * Constructor method for RelatieGegevens
     * @uses RelatieGegevens::setBezitEigenWoning()
     * @uses RelatieGegevens::setGeslacht()
     * @uses RelatieGegevens::setHuisnummer()
     * @uses RelatieGegevens::setNaam()
     * @uses RelatieGegevens::setPlaats()
     * @uses RelatieGegevens::setPostcode()
     * @uses RelatieGegevens::setStraatnaam()
     * @uses RelatieGegevens::setVoorletters()
     * @uses RelatieGegevens::setRoepnaam()
     * @uses RelatieGegevens::setVoornamen()
     * @uses RelatieGegevens::setNationaliteit()
     * @uses RelatieGegevens::setHerkomst()
     * @uses RelatieGegevens::setPersoonlijkeInformatie()
     * @uses RelatieGegevens::setRecID()
     * @uses RelatieGegevens::setBedrijfsnaam()
     * @uses RelatieGegevens::setBurgerlijkeStaat()
     * @uses RelatieGegevens::setGeboortedatum()
     * @uses RelatieGegevens::setGeboorteplaats()
     * @uses RelatieGegevens::setLand()
     * @uses RelatieGegevens::setPartnerID()
     * @uses RelatieGegevens::setToevoeging()
     * @uses RelatieGegevens::setTussenvoegsel()
     * @uses RelatieGegevens::setBIC()
     * @uses RelatieGegevens::setRekeningnummer()
     * @uses RelatieGegevens::setLegitimatiebewijs()
     * @uses RelatieGegevens::setNummerLegitimatiebewijs()
     * @uses RelatieGegevens::setDatumUitgifteLegitimatiebewijs()
     * @uses RelatieGegevens::setPlaatsUitgifteLegitimatiebewijs()
     * @uses RelatieGegevens::setInkomenPerMaand()
     * @uses RelatieGegevens::setMaandelijkseTermijnen()
     * @uses RelatieGegevens::setBeschikbaarVermogen()
     * @uses RelatieGegevens::setAccountmanagerID()
     * @uses RelatieGegevens::setDataDelenGUID()
     * @uses RelatieGegevens::setAantalKinderen()
     * @uses RelatieGegevens::setAantalVolwassenen()
     * @uses RelatieGegevens::setGeschatteVerkoopWaarde()
     * @uses RelatieGegevens::setHoogteHypotheek()
     * @uses RelatieGegevens::setInvoerdatum()
     * @uses RelatieGegevens::setSoortDienstverband()
     * @uses RelatieGegevens::setHuidigeWoning()
     * @uses RelatieGegevens::setTaal()
     * @param bool $bezitEigenWoning
     * @param string $geslacht
     * @param int $huisnummer
     * @param string $naam
     * @param string $plaats
     * @param string $postcode
     * @param string $straatnaam
     * @param string $voorletters
     * @param string $roepnaam
     * @param string $voornamen
     * @param string $nationaliteit
     * @param string $herkomst
     * @param string $persoonlijkeInformatie
     * @param int $recID
     * @param string $bedrijfsnaam
     * @param string $burgerlijkeStaat
     * @param string $geboortedatum
     * @param string $geboorteplaats
     * @param string $land
     * @param int $partnerID
     * @param string $toevoeging
     * @param string $tussenvoegsel
     * @param string $bIC
     * @param string $rekeningnummer
     * @param string $legitimatiebewijs
     * @param string $nummerLegitimatiebewijs
     * @param string $datumUitgifteLegitimatiebewijs
     * @param string $plaatsUitgifteLegitimatiebewijs
     * @param int $inkomenPerMaand
     * @param float $maandelijkseTermijnen
     * @param int $beschikbaarVermogen
     * @param int $accountmanagerID
     * @param string $dataDelenGUID
     * @param int $aantalKinderen
     * @param int $aantalVolwassenen
     * @param int $geschatteVerkoopWaarde
     * @param int $hoogteHypotheek
     * @param string $invoerdatum
     * @param string $soortDienstverband
     * @param string $huidigeWoning
     * @param string $taal
     */
    public function __construct($bezitEigenWoning = null, $geslacht = null, $huisnummer = null, $naam = null, $plaats = null, $postcode = null, $straatnaam = null, $voorletters = null, $roepnaam = null, $voornamen = null, $nationaliteit = null, $herkomst = null, $persoonlijkeInformatie = null, $recID = null, $bedrijfsnaam = null, $burgerlijkeStaat = null, $geboortedatum = null, $geboorteplaats = null, $land = null, $partnerID = null, $toevoeging = null, $tussenvoegsel = null, $bIC = null, $rekeningnummer = null, $legitimatiebewijs = null, $nummerLegitimatiebewijs = null, $datumUitgifteLegitimatiebewijs = null, $plaatsUitgifteLegitimatiebewijs = null, $inkomenPerMaand = null, $maandelijkseTermijnen = null, $beschikbaarVermogen = null, $accountmanagerID = null, $dataDelenGUID = null, $aantalKinderen = null, $aantalVolwassenen = null, $geschatteVerkoopWaarde = null, $hoogteHypotheek = null, $invoerdatum = null, $soortDienstverband = null, $huidigeWoning = null, $taal = null)
    {
        $this
            ->setBezitEigenWoning($bezitEigenWoning)
            ->setGeslacht($geslacht)
            ->setHuisnummer($huisnummer)
            ->setNaam($naam)
            ->setPlaats($plaats)
            ->setPostcode($postcode)
            ->setStraatnaam($straatnaam)
            ->setVoorletters($voorletters)
            ->setRoepnaam($roepnaam)
            ->setVoornamen($voornamen)
            ->setNationaliteit($nationaliteit)
            ->setHerkomst($herkomst)
            ->setPersoonlijkeInformatie($persoonlijkeInformatie)
            ->setRecID($recID)
            ->setBedrijfsnaam($bedrijfsnaam)
            ->setBurgerlijkeStaat($burgerlijkeStaat)
            ->setGeboortedatum($geboortedatum)
            ->setGeboorteplaats($geboorteplaats)
            ->setLand($land)
            ->setPartnerID($partnerID)
            ->setToevoeging($toevoeging)
            ->setTussenvoegsel($tussenvoegsel)
            ->setBIC($bIC)
            ->setRekeningnummer($rekeningnummer)
            ->setLegitimatiebewijs($legitimatiebewijs)
            ->setNummerLegitimatiebewijs($nummerLegitimatiebewijs)
            ->setDatumUitgifteLegitimatiebewijs($datumUitgifteLegitimatiebewijs)
            ->setPlaatsUitgifteLegitimatiebewijs($plaatsUitgifteLegitimatiebewijs)
            ->setInkomenPerMaand($inkomenPerMaand)
            ->setMaandelijkseTermijnen($maandelijkseTermijnen)
            ->setBeschikbaarVermogen($beschikbaarVermogen)
            ->setAccountmanagerID($accountmanagerID)
            ->setDataDelenGUID($dataDelenGUID)
            ->setAantalKinderen($aantalKinderen)
            ->setAantalVolwassenen($aantalVolwassenen)
            ->setGeschatteVerkoopWaarde($geschatteVerkoopWaarde)
            ->setHoogteHypotheek($hoogteHypotheek)
            ->setInvoerdatum($invoerdatum)
            ->setSoortDienstverband($soortDienstverband)
            ->setHuidigeWoning($huidigeWoning)
            ->setTaal($taal);
    }
    /**
     * Get BezitEigenWoning value
     * @return bool
     */
    public function getBezitEigenWoning()
    {
        return $this->BezitEigenWoning;
    }
    /**
     * Set BezitEigenWoning value
     * @param bool $bezitEigenWoning
     * @return \StructType\RelatieGegevens
     */
    public function setBezitEigenWoning($bezitEigenWoning = null)
    {
        // validation for constraint: boolean
        if (!is_null($bezitEigenWoning) && !is_bool($bezitEigenWoning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bezitEigenWoning)), __LINE__);
        }
        $this->BezitEigenWoning = $bezitEigenWoning;
        return $this;
    }
    /**
     * Get Geslacht value
     * @return string
     */
    public function getGeslacht()
    {
        return $this->Geslacht;
    }
    /**
     * Set Geslacht value
     * @uses \EnumType\GeslachtType::valueIsValid()
     * @uses \EnumType\GeslachtType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geslacht
     * @return \StructType\RelatieGegevens
     */
    public function setGeslacht($geslacht = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GeslachtType::valueIsValid($geslacht)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geslacht, implode(', ', \EnumType\GeslachtType::getValidValues())), __LINE__);
        }
        $this->Geslacht = $geslacht;
        return $this;
    }
    /**
     * Get Huisnummer value
     * @return int
     */
    public function getHuisnummer()
    {
        return $this->Huisnummer;
    }
    /**
     * Set Huisnummer value
     * @param int $huisnummer
     * @return \StructType\RelatieGegevens
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: int
        if (!is_null($huisnummer) && !is_numeric($huisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($huisnummer)), __LINE__);
        }
        $this->Huisnummer = $huisnummer;
        return $this;
    }
    /**
     * Get Naam value
     * @return string
     */
    public function getNaam()
    {
        return $this->Naam;
    }
    /**
     * Set Naam value
     * @param string $naam
     * @return \StructType\RelatieGegevens
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naam)), __LINE__);
        }
        $this->Naam = $naam;
        return $this;
    }
    /**
     * Get Plaats value
     * @return string
     */
    public function getPlaats()
    {
        return $this->Plaats;
    }
    /**
     * Set Plaats value
     * @param string $plaats
     * @return \StructType\RelatieGegevens
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaats)), __LINE__);
        }
        $this->Plaats = $plaats;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\RelatieGegevens
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Straatnaam value
     * @return string
     */
    public function getStraatnaam()
    {
        return $this->Straatnaam;
    }
    /**
     * Set Straatnaam value
     * @param string $straatnaam
     * @return \StructType\RelatieGegevens
     */
    public function setStraatnaam($straatnaam = null)
    {
        // validation for constraint: string
        if (!is_null($straatnaam) && !is_string($straatnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($straatnaam)), __LINE__);
        }
        $this->Straatnaam = $straatnaam;
        return $this;
    }
    /**
     * Get Voorletters value
     * @return string
     */
    public function getVoorletters()
    {
        return $this->Voorletters;
    }
    /**
     * Set Voorletters value
     * @param string $voorletters
     * @return \StructType\RelatieGegevens
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voorletters)), __LINE__);
        }
        $this->Voorletters = $voorletters;
        return $this;
    }
    /**
     * Get Roepnaam value
     * @return string
     */
    public function getRoepnaam()
    {
        return $this->Roepnaam;
    }
    /**
     * Set Roepnaam value
     * @param string $roepnaam
     * @return \StructType\RelatieGegevens
     */
    public function setRoepnaam($roepnaam = null)
    {
        // validation for constraint: string
        if (!is_null($roepnaam) && !is_string($roepnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roepnaam)), __LINE__);
        }
        $this->Roepnaam = $roepnaam;
        return $this;
    }
    /**
     * Get Voornamen value
     * @return string
     */
    public function getVoornamen()
    {
        return $this->Voornamen;
    }
    /**
     * Set Voornamen value
     * @param string $voornamen
     * @return \StructType\RelatieGegevens
     */
    public function setVoornamen($voornamen = null)
    {
        // validation for constraint: string
        if (!is_null($voornamen) && !is_string($voornamen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voornamen)), __LINE__);
        }
        $this->Voornamen = $voornamen;
        return $this;
    }
    /**
     * Get Nationaliteit value
     * @return string
     */
    public function getNationaliteit()
    {
        return $this->Nationaliteit;
    }
    /**
     * Set Nationaliteit value
     * @param string $nationaliteit
     * @return \StructType\RelatieGegevens
     */
    public function setNationaliteit($nationaliteit = null)
    {
        // validation for constraint: string
        if (!is_null($nationaliteit) && !is_string($nationaliteit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationaliteit)), __LINE__);
        }
        $this->Nationaliteit = $nationaliteit;
        return $this;
    }
    /**
     * Get Herkomst value
     * @return string
     */
    public function getHerkomst()
    {
        return $this->Herkomst;
    }
    /**
     * Set Herkomst value
     * @param string $herkomst
     * @return \StructType\RelatieGegevens
     */
    public function setHerkomst($herkomst = null)
    {
        // validation for constraint: string
        if (!is_null($herkomst) && !is_string($herkomst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($herkomst)), __LINE__);
        }
        $this->Herkomst = $herkomst;
        return $this;
    }
    /**
     * Get PersoonlijkeInformatie value
     * @return string
     */
    public function getPersoonlijkeInformatie()
    {
        return $this->PersoonlijkeInformatie;
    }
    /**
     * Set PersoonlijkeInformatie value
     * @param string $persoonlijkeInformatie
     * @return \StructType\RelatieGegevens
     */
    public function setPersoonlijkeInformatie($persoonlijkeInformatie = null)
    {
        // validation for constraint: string
        if (!is_null($persoonlijkeInformatie) && !is_string($persoonlijkeInformatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($persoonlijkeInformatie)), __LINE__);
        }
        $this->PersoonlijkeInformatie = $persoonlijkeInformatie;
        return $this;
    }
    /**
     * Get RecID value
     * @return int|null
     */
    public function getRecID()
    {
        return $this->RecID;
    }
    /**
     * Set RecID value
     * @param int $recID
     * @return \StructType\RelatieGegevens
     */
    public function setRecID($recID = null)
    {
        // validation for constraint: int
        if (!is_null($recID) && !is_numeric($recID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recID)), __LINE__);
        }
        $this->RecID = $recID;
        return $this;
    }
    /**
     * Get Bedrijfsnaam value
     * @return string|null
     */
    public function getBedrijfsnaam()
    {
        return $this->Bedrijfsnaam;
    }
    /**
     * Set Bedrijfsnaam value
     * @param string $bedrijfsnaam
     * @return \StructType\RelatieGegevens
     */
    public function setBedrijfsnaam($bedrijfsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($bedrijfsnaam) && !is_string($bedrijfsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bedrijfsnaam)), __LINE__);
        }
        $this->Bedrijfsnaam = $bedrijfsnaam;
        return $this;
    }
    /**
     * Get BurgerlijkeStaat value
     * @return string|null
     */
    public function getBurgerlijkeStaat()
    {
        return $this->BurgerlijkeStaat;
    }
    /**
     * Set BurgerlijkeStaat value
     * @param string $burgerlijkeStaat
     * @return \StructType\RelatieGegevens
     */
    public function setBurgerlijkeStaat($burgerlijkeStaat = null)
    {
        // validation for constraint: string
        if (!is_null($burgerlijkeStaat) && !is_string($burgerlijkeStaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($burgerlijkeStaat)), __LINE__);
        }
        $this->BurgerlijkeStaat = $burgerlijkeStaat;
        return $this;
    }
    /**
     * Get Geboortedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboortedatum()
    {
        return isset($this->Geboortedatum) ? $this->Geboortedatum : null;
    }
    /**
     * Set Geboortedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboortedatum
     * @return \StructType\RelatieGegevens
     */
    public function setGeboortedatum($geboortedatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboortedatum) && !is_string($geboortedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboortedatum)), __LINE__);
        }
        if (is_null($geboortedatum) || (is_array($geboortedatum) && empty($geboortedatum))) {
            unset($this->Geboortedatum);
        } else {
            $this->Geboortedatum = $geboortedatum;
        }
        return $this;
    }
    /**
     * Get Geboorteplaats value
     * @return string|null
     */
    public function getGeboorteplaats()
    {
        return $this->Geboorteplaats;
    }
    /**
     * Set Geboorteplaats value
     * @param string $geboorteplaats
     * @return \StructType\RelatieGegevens
     */
    public function setGeboorteplaats($geboorteplaats = null)
    {
        // validation for constraint: string
        if (!is_null($geboorteplaats) && !is_string($geboorteplaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geboorteplaats)), __LINE__);
        }
        $this->Geboorteplaats = $geboorteplaats;
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @param string $land
     * @return \StructType\RelatieGegevens
     */
    public function setLand($land = null)
    {
        // validation for constraint: string
        if (!is_null($land) && !is_string($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($land)), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get PartnerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPartnerID()
    {
        return isset($this->PartnerID) ? $this->PartnerID : null;
    }
    /**
     * Set PartnerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $partnerID
     * @return \StructType\RelatieGegevens
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: int
        if (!is_null($partnerID) && !is_numeric($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partnerID)), __LINE__);
        }
        if (is_null($partnerID) || (is_array($partnerID) && empty($partnerID))) {
            unset($this->PartnerID);
        } else {
            $this->PartnerID = $partnerID;
        }
        return $this;
    }
    /**
     * Get Toevoeging value
     * @return string|null
     */
    public function getToevoeging()
    {
        return $this->Toevoeging;
    }
    /**
     * Set Toevoeging value
     * @param string $toevoeging
     * @return \StructType\RelatieGegevens
     */
    public function setToevoeging($toevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($toevoeging) && !is_string($toevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toevoeging)), __LINE__);
        }
        $this->Toevoeging = $toevoeging;
        return $this;
    }
    /**
     * Get Tussenvoegsel value
     * @return string|null
     */
    public function getTussenvoegsel()
    {
        return $this->Tussenvoegsel;
    }
    /**
     * Set Tussenvoegsel value
     * @param string $tussenvoegsel
     * @return \StructType\RelatieGegevens
     */
    public function setTussenvoegsel($tussenvoegsel = null)
    {
        // validation for constraint: string
        if (!is_null($tussenvoegsel) && !is_string($tussenvoegsel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tussenvoegsel)), __LINE__);
        }
        $this->Tussenvoegsel = $tussenvoegsel;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \StructType\RelatieGegevens
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bIC)), __LINE__);
        }
        $this->BIC = $bIC;
        return $this;
    }
    /**
     * Get Rekeningnummer value
     * @return string|null
     */
    public function getRekeningnummer()
    {
        return $this->Rekeningnummer;
    }
    /**
     * Set Rekeningnummer value
     * @param string $rekeningnummer
     * @return \StructType\RelatieGegevens
     */
    public function setRekeningnummer($rekeningnummer = null)
    {
        // validation for constraint: string
        if (!is_null($rekeningnummer) && !is_string($rekeningnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rekeningnummer)), __LINE__);
        }
        $this->Rekeningnummer = $rekeningnummer;
        return $this;
    }
    /**
     * Get Legitimatiebewijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegitimatiebewijs()
    {
        return isset($this->Legitimatiebewijs) ? $this->Legitimatiebewijs : null;
    }
    /**
     * Set Legitimatiebewijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\TypeLegitimatiebewijs::valueIsValid()
     * @uses \EnumType\TypeLegitimatiebewijs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $legitimatiebewijs
     * @return \StructType\RelatieGegevens
     */
    public function setLegitimatiebewijs($legitimatiebewijs = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeLegitimatiebewijs::valueIsValid($legitimatiebewijs)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $legitimatiebewijs, implode(', ', \EnumType\TypeLegitimatiebewijs::getValidValues())), __LINE__);
        }
        if (is_null($legitimatiebewijs) || (is_array($legitimatiebewijs) && empty($legitimatiebewijs))) {
            unset($this->Legitimatiebewijs);
        } else {
            $this->Legitimatiebewijs = $legitimatiebewijs;
        }
        return $this;
    }
    /**
     * Get NummerLegitimatiebewijs value
     * @return string|null
     */
    public function getNummerLegitimatiebewijs()
    {
        return $this->NummerLegitimatiebewijs;
    }
    /**
     * Set NummerLegitimatiebewijs value
     * @param string $nummerLegitimatiebewijs
     * @return \StructType\RelatieGegevens
     */
    public function setNummerLegitimatiebewijs($nummerLegitimatiebewijs = null)
    {
        // validation for constraint: string
        if (!is_null($nummerLegitimatiebewijs) && !is_string($nummerLegitimatiebewijs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nummerLegitimatiebewijs)), __LINE__);
        }
        $this->NummerLegitimatiebewijs = $nummerLegitimatiebewijs;
        return $this;
    }
    /**
     * Get DatumUitgifteLegitimatiebewijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumUitgifteLegitimatiebewijs()
    {
        return isset($this->DatumUitgifteLegitimatiebewijs) ? $this->DatumUitgifteLegitimatiebewijs : null;
    }
    /**
     * Set DatumUitgifteLegitimatiebewijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumUitgifteLegitimatiebewijs
     * @return \StructType\RelatieGegevens
     */
    public function setDatumUitgifteLegitimatiebewijs($datumUitgifteLegitimatiebewijs = null)
    {
        // validation for constraint: string
        if (!is_null($datumUitgifteLegitimatiebewijs) && !is_string($datumUitgifteLegitimatiebewijs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumUitgifteLegitimatiebewijs)), __LINE__);
        }
        if (is_null($datumUitgifteLegitimatiebewijs) || (is_array($datumUitgifteLegitimatiebewijs) && empty($datumUitgifteLegitimatiebewijs))) {
            unset($this->DatumUitgifteLegitimatiebewijs);
        } else {
            $this->DatumUitgifteLegitimatiebewijs = $datumUitgifteLegitimatiebewijs;
        }
        return $this;
    }
    /**
     * Get PlaatsUitgifteLegitimatiebewijs value
     * @return string|null
     */
    public function getPlaatsUitgifteLegitimatiebewijs()
    {
        return $this->PlaatsUitgifteLegitimatiebewijs;
    }
    /**
     * Set PlaatsUitgifteLegitimatiebewijs value
     * @param string $plaatsUitgifteLegitimatiebewijs
     * @return \StructType\RelatieGegevens
     */
    public function setPlaatsUitgifteLegitimatiebewijs($plaatsUitgifteLegitimatiebewijs = null)
    {
        // validation for constraint: string
        if (!is_null($plaatsUitgifteLegitimatiebewijs) && !is_string($plaatsUitgifteLegitimatiebewijs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plaatsUitgifteLegitimatiebewijs)), __LINE__);
        }
        $this->PlaatsUitgifteLegitimatiebewijs = $plaatsUitgifteLegitimatiebewijs;
        return $this;
    }
    /**
     * Get InkomenPerMaand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInkomenPerMaand()
    {
        return isset($this->InkomenPerMaand) ? $this->InkomenPerMaand : null;
    }
    /**
     * Set InkomenPerMaand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inkomenPerMaand
     * @return \StructType\RelatieGegevens
     */
    public function setInkomenPerMaand($inkomenPerMaand = null)
    {
        // validation for constraint: int
        if (!is_null($inkomenPerMaand) && !is_numeric($inkomenPerMaand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inkomenPerMaand)), __LINE__);
        }
        if (is_null($inkomenPerMaand) || (is_array($inkomenPerMaand) && empty($inkomenPerMaand))) {
            unset($this->InkomenPerMaand);
        } else {
            $this->InkomenPerMaand = $inkomenPerMaand;
        }
        return $this;
    }
    /**
     * Get MaandelijkseTermijnen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaandelijkseTermijnen()
    {
        return isset($this->MaandelijkseTermijnen) ? $this->MaandelijkseTermijnen : null;
    }
    /**
     * Set MaandelijkseTermijnen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maandelijkseTermijnen
     * @return \StructType\RelatieGegevens
     */
    public function setMaandelijkseTermijnen($maandelijkseTermijnen = null)
    {
        if (is_null($maandelijkseTermijnen) || (is_array($maandelijkseTermijnen) && empty($maandelijkseTermijnen))) {
            unset($this->MaandelijkseTermijnen);
        } else {
            $this->MaandelijkseTermijnen = $maandelijkseTermijnen;
        }
        return $this;
    }
    /**
     * Get BeschikbaarVermogen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBeschikbaarVermogen()
    {
        return isset($this->BeschikbaarVermogen) ? $this->BeschikbaarVermogen : null;
    }
    /**
     * Set BeschikbaarVermogen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $beschikbaarVermogen
     * @return \StructType\RelatieGegevens
     */
    public function setBeschikbaarVermogen($beschikbaarVermogen = null)
    {
        // validation for constraint: int
        if (!is_null($beschikbaarVermogen) && !is_numeric($beschikbaarVermogen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($beschikbaarVermogen)), __LINE__);
        }
        if (is_null($beschikbaarVermogen) || (is_array($beschikbaarVermogen) && empty($beschikbaarVermogen))) {
            unset($this->BeschikbaarVermogen);
        } else {
            $this->BeschikbaarVermogen = $beschikbaarVermogen;
        }
        return $this;
    }
    /**
     * Get AccountmanagerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAccountmanagerID()
    {
        return isset($this->AccountmanagerID) ? $this->AccountmanagerID : null;
    }
    /**
     * Set AccountmanagerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $accountmanagerID
     * @return \StructType\RelatieGegevens
     */
    public function setAccountmanagerID($accountmanagerID = null)
    {
        // validation for constraint: int
        if (!is_null($accountmanagerID) && !is_numeric($accountmanagerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountmanagerID)), __LINE__);
        }
        if (is_null($accountmanagerID) || (is_array($accountmanagerID) && empty($accountmanagerID))) {
            unset($this->AccountmanagerID);
        } else {
            $this->AccountmanagerID = $accountmanagerID;
        }
        return $this;
    }
    /**
     * Get DataDelenGUID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDelenGUID()
    {
        return isset($this->DataDelenGUID) ? $this->DataDelenGUID : null;
    }
    /**
     * Set DataDelenGUID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDelenGUID
     * @return \StructType\RelatieGegevens
     */
    public function setDataDelenGUID($dataDelenGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dataDelenGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $dataDelenGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($dataDelenGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataDelenGUID) && !is_string($dataDelenGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDelenGUID)), __LINE__);
        }
        if (is_null($dataDelenGUID) || (is_array($dataDelenGUID) && empty($dataDelenGUID))) {
            unset($this->DataDelenGUID);
        } else {
            $this->DataDelenGUID = $dataDelenGUID;
        }
        return $this;
    }
    /**
     * Get AantalKinderen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalKinderen()
    {
        return isset($this->AantalKinderen) ? $this->AantalKinderen : null;
    }
    /**
     * Set AantalKinderen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalKinderen
     * @return \StructType\RelatieGegevens
     */
    public function setAantalKinderen($aantalKinderen = null)
    {
        // validation for constraint: int
        if (!is_null($aantalKinderen) && !is_numeric($aantalKinderen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantalKinderen)), __LINE__);
        }
        if (is_null($aantalKinderen) || (is_array($aantalKinderen) && empty($aantalKinderen))) {
            unset($this->AantalKinderen);
        } else {
            $this->AantalKinderen = $aantalKinderen;
        }
        return $this;
    }
    /**
     * Get AantalVolwassenen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalVolwassenen()
    {
        return isset($this->AantalVolwassenen) ? $this->AantalVolwassenen : null;
    }
    /**
     * Set AantalVolwassenen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalVolwassenen
     * @return \StructType\RelatieGegevens
     */
    public function setAantalVolwassenen($aantalVolwassenen = null)
    {
        // validation for constraint: int
        if (!is_null($aantalVolwassenen) && !is_numeric($aantalVolwassenen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aantalVolwassenen)), __LINE__);
        }
        if (is_null($aantalVolwassenen) || (is_array($aantalVolwassenen) && empty($aantalVolwassenen))) {
            unset($this->AantalVolwassenen);
        } else {
            $this->AantalVolwassenen = $aantalVolwassenen;
        }
        return $this;
    }
    /**
     * Get GeschatteVerkoopWaarde value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGeschatteVerkoopWaarde()
    {
        return isset($this->GeschatteVerkoopWaarde) ? $this->GeschatteVerkoopWaarde : null;
    }
    /**
     * Set GeschatteVerkoopWaarde value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $geschatteVerkoopWaarde
     * @return \StructType\RelatieGegevens
     */
    public function setGeschatteVerkoopWaarde($geschatteVerkoopWaarde = null)
    {
        // validation for constraint: int
        if (!is_null($geschatteVerkoopWaarde) && !is_numeric($geschatteVerkoopWaarde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($geschatteVerkoopWaarde)), __LINE__);
        }
        if (is_null($geschatteVerkoopWaarde) || (is_array($geschatteVerkoopWaarde) && empty($geschatteVerkoopWaarde))) {
            unset($this->GeschatteVerkoopWaarde);
        } else {
            $this->GeschatteVerkoopWaarde = $geschatteVerkoopWaarde;
        }
        return $this;
    }
    /**
     * Get HoogteHypotheek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHoogteHypotheek()
    {
        return isset($this->HoogteHypotheek) ? $this->HoogteHypotheek : null;
    }
    /**
     * Set HoogteHypotheek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hoogteHypotheek
     * @return \StructType\RelatieGegevens
     */
    public function setHoogteHypotheek($hoogteHypotheek = null)
    {
        // validation for constraint: int
        if (!is_null($hoogteHypotheek) && !is_numeric($hoogteHypotheek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hoogteHypotheek)), __LINE__);
        }
        if (is_null($hoogteHypotheek) || (is_array($hoogteHypotheek) && empty($hoogteHypotheek))) {
            unset($this->HoogteHypotheek);
        } else {
            $this->HoogteHypotheek = $hoogteHypotheek;
        }
        return $this;
    }
    /**
     * Get Invoerdatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoerdatum()
    {
        return isset($this->Invoerdatum) ? $this->Invoerdatum : null;
    }
    /**
     * Set Invoerdatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoerdatum
     * @return \StructType\RelatieGegevens
     */
    public function setInvoerdatum($invoerdatum = null)
    {
        // validation for constraint: string
        if (!is_null($invoerdatum) && !is_string($invoerdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoerdatum)), __LINE__);
        }
        if (is_null($invoerdatum) || (is_array($invoerdatum) && empty($invoerdatum))) {
            unset($this->Invoerdatum);
        } else {
            $this->Invoerdatum = $invoerdatum;
        }
        return $this;
    }
    /**
     * Get SoortDienstverband value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSoortDienstverband()
    {
        return isset($this->SoortDienstverband) ? $this->SoortDienstverband : null;
    }
    /**
     * Set SoortDienstverband value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\TypeSoortDienstVerband::valueIsValid()
     * @uses \EnumType\TypeSoortDienstVerband::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $soortDienstverband
     * @return \StructType\RelatieGegevens
     */
    public function setSoortDienstverband($soortDienstverband = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeSoortDienstVerband::valueIsValid($soortDienstverband)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $soortDienstverband, implode(', ', \EnumType\TypeSoortDienstVerband::getValidValues())), __LINE__);
        }
        if (is_null($soortDienstverband) || (is_array($soortDienstverband) && empty($soortDienstverband))) {
            unset($this->SoortDienstverband);
        } else {
            $this->SoortDienstverband = $soortDienstverband;
        }
        return $this;
    }
    /**
     * Get HuidigeWoning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuidigeWoning()
    {
        return isset($this->HuidigeWoning) ? $this->HuidigeWoning : null;
    }
    /**
     * Set HuidigeWoning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\TypeHuidigeWoning::valueIsValid()
     * @uses \EnumType\TypeHuidigeWoning::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huidigeWoning
     * @return \StructType\RelatieGegevens
     */
    public function setHuidigeWoning($huidigeWoning = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeHuidigeWoning::valueIsValid($huidigeWoning)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huidigeWoning, implode(', ', \EnumType\TypeHuidigeWoning::getValidValues())), __LINE__);
        }
        if (is_null($huidigeWoning) || (is_array($huidigeWoning) && empty($huidigeWoning))) {
            unset($this->HuidigeWoning);
        } else {
            $this->HuidigeWoning = $huidigeWoning;
        }
        return $this;
    }
    /**
     * Get Taal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaal()
    {
        return isset($this->Taal) ? $this->Taal : null;
    }
    /**
     * Set Taal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\TypeTaalcode::valueIsValid()
     * @uses \EnumType\TypeTaalcode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taal
     * @return \StructType\RelatieGegevens
     */
    public function setTaal($taal = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeTaalcode::valueIsValid($taal)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $taal, implode(', ', \EnumType\TypeTaalcode::getValidValues())), __LINE__);
        }
        if (is_null($taal) || (is_array($taal) && empty($taal))) {
            unset($this->Taal);
        } else {
            $this->Taal = $taal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatieGegevens
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
