<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGUID StructType
 * @subpackage Structs
 */
class GetGUID extends AbstractStructBase
{
    /**
     * The RecID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecID;
    /**
     * Constructor method for GetGUID
     * @uses GetGUID::setRecID()
     * @param int $recID
     */
    public function __construct($recID = null)
    {
        $this
            ->setRecID($recID);
    }
    /**
     * Get RecID value
     * @return int
     */
    public function getRecID()
    {
        return $this->RecID;
    }
    /**
     * Set RecID value
     * @param int $recID
     * @return \StructType\GetGUID
     */
    public function setRecID($recID = null)
    {
        // validation for constraint: int
        if (!is_null($recID) && !is_numeric($recID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recID)), __LINE__);
        }
        $this->RecID = $recID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetGUID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
