<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetByDataDelenGUID StructType
 * @subpackage Structs
 */
class GetByDataDelenGUID extends AbstractStructBase
{
    /**
     * The DataDelenGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $DataDelenGUID;
    /**
     * Constructor method for GetByDataDelenGUID
     * @uses GetByDataDelenGUID::setDataDelenGUID()
     * @param string $dataDelenGUID
     */
    public function __construct($dataDelenGUID = null)
    {
        $this
            ->setDataDelenGUID($dataDelenGUID);
    }
    /**
     * Get DataDelenGUID value
     * @return string
     */
    public function getDataDelenGUID()
    {
        return $this->DataDelenGUID;
    }
    /**
     * Set DataDelenGUID value
     * @param string $dataDelenGUID
     * @return \StructType\GetByDataDelenGUID
     */
    public function setDataDelenGUID($dataDelenGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dataDelenGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $dataDelenGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($dataDelenGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataDelenGUID) && !is_string($dataDelenGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDelenGUID)), __LINE__);
        }
        $this->DataDelenGUID = $dataDelenGUID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetByDataDelenGUID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
