<?php

namespace EnumType;

/**
 * This class stands for TypeSoortDienstVerband EnumType
 * @subpackage Enumerations
 */
class TypeSoortDienstVerband
{
    /**
     * Constant for value 'Geen'
     * @return string 'Geen'
     */
    const VALUE_GEEN = 'Geen';
    /**
     * Constant for value 'LoondienstOnbepaaldeTijd'
     * @return string 'LoondienstOnbepaaldeTijd'
     */
    const VALUE_LOONDIENST_ONBEPAALDE_TIJD = 'LoondienstOnbepaaldeTijd';
    /**
     * Constant for value 'Ondernemer'
     * @return string 'Ondernemer'
     */
    const VALUE_ONDERNEMER = 'Ondernemer';
    /**
     * Constant for value 'Uitkering'
     * @return string 'Uitkering'
     */
    const VALUE_UITKERING = 'Uitkering';
    /**
     * Constant for value 'Pensioen'
     * @return string 'Pensioen'
     */
    const VALUE_PENSIOEN = 'Pensioen';
    /**
     * Constant for value 'LoondienstBepaaldeTijd'
     * @return string 'LoondienstBepaaldeTijd'
     */
    const VALUE_LOONDIENST_BEPAALDE_TIJD = 'LoondienstBepaaldeTijd';
    /**
     * Constant for value 'Anders'
     * @return string 'Anders'
     */
    const VALUE_ANDERS = 'Anders';
    /**
     * Constant for value 'InkomenUitEigenVermogen'
     * @return string 'InkomenUitEigenVermogen'
     */
    const VALUE_INKOMEN_UIT_EIGEN_VERMOGEN = 'InkomenUitEigenVermogen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GEEN
     * @uses self::VALUE_LOONDIENST_ONBEPAALDE_TIJD
     * @uses self::VALUE_ONDERNEMER
     * @uses self::VALUE_UITKERING
     * @uses self::VALUE_PENSIOEN
     * @uses self::VALUE_LOONDIENST_BEPAALDE_TIJD
     * @uses self::VALUE_ANDERS
     * @uses self::VALUE_INKOMEN_UIT_EIGEN_VERMOGEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GEEN,
            self::VALUE_LOONDIENST_ONBEPAALDE_TIJD,
            self::VALUE_ONDERNEMER,
            self::VALUE_UITKERING,
            self::VALUE_PENSIOEN,
            self::VALUE_LOONDIENST_BEPAALDE_TIJD,
            self::VALUE_ANDERS,
            self::VALUE_INKOMEN_UIT_EIGEN_VERMOGEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
