<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marka StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Marka
 * @subpackage Structs
 */
class Marka extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The Breadcrumb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Breadcrumb;
    /**
     * The EklemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklemeTarihi;
    /**
     * The GuncellemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GuncellemeTarihi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Icerik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Icerik;
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Resim;
    /**
     * The SeoAnahtarKelime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoAnahtarKelime;
    /**
     * The SeoSayfaAciklama
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaAciklama;
    /**
     * The SeoSayfaBaslik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeoSayfaBaslik;
    /**
     * The Sira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sira;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for Marka
     * @uses Marka::setAktif()
     * @uses Marka::setBreadcrumb()
     * @uses Marka::setEklemeTarihi()
     * @uses Marka::setGuncellemeTarihi()
     * @uses Marka::setID()
     * @uses Marka::setIcerik()
     * @uses Marka::setResim()
     * @uses Marka::setSeoAnahtarKelime()
     * @uses Marka::setSeoSayfaAciklama()
     * @uses Marka::setSeoSayfaBaslik()
     * @uses Marka::setSira()
     * @uses Marka::setTanim()
     * @uses Marka::setUrl()
     * @param bool $aktif
     * @param string $breadcrumb
     * @param string $eklemeTarihi
     * @param string $guncellemeTarihi
     * @param int $iD
     * @param string $icerik
     * @param string $resim
     * @param string $seoAnahtarKelime
     * @param string $seoSayfaAciklama
     * @param string $seoSayfaBaslik
     * @param int $sira
     * @param string $tanim
     * @param string $url
     */
    public function __construct($aktif = null, $breadcrumb = null, $eklemeTarihi = null, $guncellemeTarihi = null, $iD = null, $icerik = null, $resim = null, $seoAnahtarKelime = null, $seoSayfaAciklama = null, $seoSayfaBaslik = null, $sira = null, $tanim = null, $url = null)
    {
        $this
            ->setAktif($aktif)
            ->setBreadcrumb($breadcrumb)
            ->setEklemeTarihi($eklemeTarihi)
            ->setGuncellemeTarihi($guncellemeTarihi)
            ->setID($iD)
            ->setIcerik($icerik)
            ->setResim($resim)
            ->setSeoAnahtarKelime($seoAnahtarKelime)
            ->setSeoSayfaAciklama($seoSayfaAciklama)
            ->setSeoSayfaBaslik($seoSayfaBaslik)
            ->setSira($sira)
            ->setTanim($tanim)
            ->setUrl($url);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\Marka
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get Breadcrumb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBreadcrumb()
    {
        return isset($this->Breadcrumb) ? $this->Breadcrumb : null;
    }
    /**
     * Set Breadcrumb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $breadcrumb
     * @return \StructType\Marka
     */
    public function setBreadcrumb($breadcrumb = null)
    {
        // validation for constraint: string
        if (!is_null($breadcrumb) && !is_string($breadcrumb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($breadcrumb, true), gettype($breadcrumb)), __LINE__);
        }
        if (is_null($breadcrumb) || (is_array($breadcrumb) && empty($breadcrumb))) {
            unset($this->Breadcrumb);
        } else {
            $this->Breadcrumb = $breadcrumb;
        }
        return $this;
    }
    /**
     * Get EklemeTarihi value
     * @return string|null
     */
    public function getEklemeTarihi()
    {
        return $this->EklemeTarihi;
    }
    /**
     * Set EklemeTarihi value
     * @param string $eklemeTarihi
     * @return \StructType\Marka
     */
    public function setEklemeTarihi($eklemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihi) && !is_string($eklemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihi, true), gettype($eklemeTarihi)), __LINE__);
        }
        $this->EklemeTarihi = $eklemeTarihi;
        return $this;
    }
    /**
     * Get GuncellemeTarihi value
     * @return string|null
     */
    public function getGuncellemeTarihi()
    {
        return $this->GuncellemeTarihi;
    }
    /**
     * Set GuncellemeTarihi value
     * @param string $guncellemeTarihi
     * @return \StructType\Marka
     */
    public function setGuncellemeTarihi($guncellemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($guncellemeTarihi) && !is_string($guncellemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guncellemeTarihi, true), gettype($guncellemeTarihi)), __LINE__);
        }
        $this->GuncellemeTarihi = $guncellemeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Marka
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Icerik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIcerik()
    {
        return isset($this->Icerik) ? $this->Icerik : null;
    }
    /**
     * Set Icerik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $icerik
     * @return \StructType\Marka
     */
    public function setIcerik($icerik = null)
    {
        // validation for constraint: string
        if (!is_null($icerik) && !is_string($icerik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($icerik, true), gettype($icerik)), __LINE__);
        }
        if (is_null($icerik) || (is_array($icerik) && empty($icerik))) {
            unset($this->Icerik);
        } else {
            $this->Icerik = $icerik;
        }
        return $this;
    }
    /**
     * Get Resim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResim()
    {
        return isset($this->Resim) ? $this->Resim : null;
    }
    /**
     * Set Resim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resim
     * @return \StructType\Marka
     */
    public function setResim($resim = null)
    {
        // validation for constraint: string
        if (!is_null($resim) && !is_string($resim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resim, true), gettype($resim)), __LINE__);
        }
        if (is_null($resim) || (is_array($resim) && empty($resim))) {
            unset($this->Resim);
        } else {
            $this->Resim = $resim;
        }
        return $this;
    }
    /**
     * Get SeoAnahtarKelime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoAnahtarKelime()
    {
        return isset($this->SeoAnahtarKelime) ? $this->SeoAnahtarKelime : null;
    }
    /**
     * Set SeoAnahtarKelime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoAnahtarKelime
     * @return \StructType\Marka
     */
    public function setSeoAnahtarKelime($seoAnahtarKelime = null)
    {
        // validation for constraint: string
        if (!is_null($seoAnahtarKelime) && !is_string($seoAnahtarKelime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seoAnahtarKelime, true), gettype($seoAnahtarKelime)), __LINE__);
        }
        if (is_null($seoAnahtarKelime) || (is_array($seoAnahtarKelime) && empty($seoAnahtarKelime))) {
            unset($this->SeoAnahtarKelime);
        } else {
            $this->SeoAnahtarKelime = $seoAnahtarKelime;
        }
        return $this;
    }
    /**
     * Get SeoSayfaAciklama value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaAciklama()
    {
        return isset($this->SeoSayfaAciklama) ? $this->SeoSayfaAciklama : null;
    }
    /**
     * Set SeoSayfaAciklama value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaAciklama
     * @return \StructType\Marka
     */
    public function setSeoSayfaAciklama($seoSayfaAciklama = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaAciklama) && !is_string($seoSayfaAciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seoSayfaAciklama, true), gettype($seoSayfaAciklama)), __LINE__);
        }
        if (is_null($seoSayfaAciklama) || (is_array($seoSayfaAciklama) && empty($seoSayfaAciklama))) {
            unset($this->SeoSayfaAciklama);
        } else {
            $this->SeoSayfaAciklama = $seoSayfaAciklama;
        }
        return $this;
    }
    /**
     * Get SeoSayfaBaslik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeoSayfaBaslik()
    {
        return isset($this->SeoSayfaBaslik) ? $this->SeoSayfaBaslik : null;
    }
    /**
     * Set SeoSayfaBaslik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seoSayfaBaslik
     * @return \StructType\Marka
     */
    public function setSeoSayfaBaslik($seoSayfaBaslik = null)
    {
        // validation for constraint: string
        if (!is_null($seoSayfaBaslik) && !is_string($seoSayfaBaslik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seoSayfaBaslik, true), gettype($seoSayfaBaslik)), __LINE__);
        }
        if (is_null($seoSayfaBaslik) || (is_array($seoSayfaBaslik) && empty($seoSayfaBaslik))) {
            unset($this->SeoSayfaBaslik);
        } else {
            $this->SeoSayfaBaslik = $seoSayfaBaslik;
        }
        return $this;
    }
    /**
     * Get Sira value
     * @return int|null
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\Marka
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !(is_int($sira) || ctype_digit($sira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sira, true), gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\Marka
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\Marka
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
