<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resim StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Resim
 * @subpackage Structs
 */
class Resim extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The EklemeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklemeTarihi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The ResimAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimAdi;
    /**
     * The Sira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sira;
    /**
     * The UrunID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunID;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * Constructor method for Resim
     * @uses Resim::setAktif()
     * @uses Resim::setEklemeTarihi()
     * @uses Resim::setID()
     * @uses Resim::setResimAdi()
     * @uses Resim::setSira()
     * @uses Resim::setUrunID()
     * @uses Resim::setUrunKartiID()
     * @param bool $aktif
     * @param string $eklemeTarihi
     * @param int $iD
     * @param string $resimAdi
     * @param int $sira
     * @param int $urunID
     * @param int $urunKartiID
     */
    public function __construct($aktif = null, $eklemeTarihi = null, $iD = null, $resimAdi = null, $sira = null, $urunID = null, $urunKartiID = null)
    {
        $this
            ->setAktif($aktif)
            ->setEklemeTarihi($eklemeTarihi)
            ->setID($iD)
            ->setResimAdi($resimAdi)
            ->setSira($sira)
            ->setUrunID($urunID)
            ->setUrunKartiID($urunKartiID);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\Resim
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get EklemeTarihi value
     * @return string|null
     */
    public function getEklemeTarihi()
    {
        return $this->EklemeTarihi;
    }
    /**
     * Set EklemeTarihi value
     * @param string $eklemeTarihi
     * @return \StructType\Resim
     */
    public function setEklemeTarihi($eklemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihi) && !is_string($eklemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihi, true), gettype($eklemeTarihi)), __LINE__);
        }
        $this->EklemeTarihi = $eklemeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Resim
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ResimAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimAdi()
    {
        return isset($this->ResimAdi) ? $this->ResimAdi : null;
    }
    /**
     * Set ResimAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimAdi
     * @return \StructType\Resim
     */
    public function setResimAdi($resimAdi = null)
    {
        // validation for constraint: string
        if (!is_null($resimAdi) && !is_string($resimAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimAdi, true), gettype($resimAdi)), __LINE__);
        }
        if (is_null($resimAdi) || (is_array($resimAdi) && empty($resimAdi))) {
            unset($this->ResimAdi);
        } else {
            $this->ResimAdi = $resimAdi;
        }
        return $this;
    }
    /**
     * Get Sira value
     * @return int|null
     */
    public function getSira()
    {
        return $this->Sira;
    }
    /**
     * Set Sira value
     * @param int $sira
     * @return \StructType\Resim
     */
    public function setSira($sira = null)
    {
        // validation for constraint: int
        if (!is_null($sira) && !(is_int($sira) || ctype_digit($sira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sira, true), gettype($sira)), __LINE__);
        }
        $this->Sira = $sira;
        return $this;
    }
    /**
     * Get UrunID value
     * @return int|null
     */
    public function getUrunID()
    {
        return $this->UrunID;
    }
    /**
     * Set UrunID value
     * @param int $urunID
     * @return \StructType\Resim
     */
    public function setUrunID($urunID = null)
    {
        // validation for constraint: int
        if (!is_null($urunID) && !(is_int($urunID) || ctype_digit($urunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunID, true), gettype($urunID)), __LINE__);
        }
        $this->UrunID = $urunID;
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\Resim
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Resim
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
