<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Urun360ResimYukleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Urun360ResimYukleRequest
 * @subpackage Structs
 */
class Urun360ResimYukleRequest extends AbstractStructBase
{
    /**
     * The Dosya
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dosya;
    /**
     * The EslestirmeTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EslestirmeTipi;
    /**
     * The Resim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Resim;
    /**
     * The ResimAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimAdi;
    /**
     * The ResimFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimFormat;
    /**
     * The ResimSira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResimSira;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * Constructor method for Urun360ResimYukleRequest
     * @uses Urun360ResimYukleRequest::setDosya()
     * @uses Urun360ResimYukleRequest::setEslestirmeTipi()
     * @uses Urun360ResimYukleRequest::setResim()
     * @uses Urun360ResimYukleRequest::setResimAdi()
     * @uses Urun360ResimYukleRequest::setResimFormat()
     * @uses Urun360ResimYukleRequest::setResimSira()
     * @uses Urun360ResimYukleRequest::setUrunKartiID()
     * @param string $dosya
     * @param string $eslestirmeTipi
     * @param string $resim
     * @param string $resimAdi
     * @param string $resimFormat
     * @param int $resimSira
     * @param int $urunKartiID
     */
    public function __construct($dosya = null, $eslestirmeTipi = null, $resim = null, $resimAdi = null, $resimFormat = null, $resimSira = null, $urunKartiID = null)
    {
        $this
            ->setDosya($dosya)
            ->setEslestirmeTipi($eslestirmeTipi)
            ->setResim($resim)
            ->setResimAdi($resimAdi)
            ->setResimFormat($resimFormat)
            ->setResimSira($resimSira)
            ->setUrunKartiID($urunKartiID);
    }
    /**
     * Get Dosya value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDosya()
    {
        return isset($this->Dosya) ? $this->Dosya : null;
    }
    /**
     * Set Dosya value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dosya
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setDosya($dosya = null)
    {
        // validation for constraint: string
        if (!is_null($dosya) && !is_string($dosya)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dosya, true), gettype($dosya)), __LINE__);
        }
        if (is_null($dosya) || (is_array($dosya) && empty($dosya))) {
            unset($this->Dosya);
        } else {
            $this->Dosya = $dosya;
        }
        return $this;
    }
    /**
     * Get EslestirmeTipi value
     * @return string|null
     */
    public function getEslestirmeTipi()
    {
        return $this->EslestirmeTipi;
    }
    /**
     * Set EslestirmeTipi value
     * @uses \EnumType\WebUrunResimEslestirmeTipi::valueIsValid()
     * @uses \EnumType\WebUrunResimEslestirmeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eslestirmeTipi
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setEslestirmeTipi($eslestirmeTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebUrunResimEslestirmeTipi::valueIsValid($eslestirmeTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebUrunResimEslestirmeTipi', is_array($eslestirmeTipi) ? implode(', ', $eslestirmeTipi) : var_export($eslestirmeTipi, true), implode(', ', \EnumType\WebUrunResimEslestirmeTipi::getValidValues())), __LINE__);
        }
        $this->EslestirmeTipi = $eslestirmeTipi;
        return $this;
    }
    /**
     * Get Resim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResim()
    {
        return isset($this->Resim) ? $this->Resim : null;
    }
    /**
     * Set Resim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resim
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setResim($resim = null)
    {
        // validation for constraint: string
        if (!is_null($resim) && !is_string($resim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resim, true), gettype($resim)), __LINE__);
        }
        if (is_null($resim) || (is_array($resim) && empty($resim))) {
            unset($this->Resim);
        } else {
            $this->Resim = $resim;
        }
        return $this;
    }
    /**
     * Get ResimAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimAdi()
    {
        return isset($this->ResimAdi) ? $this->ResimAdi : null;
    }
    /**
     * Set ResimAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimAdi
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setResimAdi($resimAdi = null)
    {
        // validation for constraint: string
        if (!is_null($resimAdi) && !is_string($resimAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimAdi, true), gettype($resimAdi)), __LINE__);
        }
        if (is_null($resimAdi) || (is_array($resimAdi) && empty($resimAdi))) {
            unset($this->ResimAdi);
        } else {
            $this->ResimAdi = $resimAdi;
        }
        return $this;
    }
    /**
     * Get ResimFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimFormat()
    {
        return isset($this->ResimFormat) ? $this->ResimFormat : null;
    }
    /**
     * Set ResimFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimFormat
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setResimFormat($resimFormat = null)
    {
        // validation for constraint: string
        if (!is_null($resimFormat) && !is_string($resimFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimFormat, true), gettype($resimFormat)), __LINE__);
        }
        if (is_null($resimFormat) || (is_array($resimFormat) && empty($resimFormat))) {
            unset($this->ResimFormat);
        } else {
            $this->ResimFormat = $resimFormat;
        }
        return $this;
    }
    /**
     * Get ResimSira value
     * @return int|null
     */
    public function getResimSira()
    {
        return $this->ResimSira;
    }
    /**
     * Set ResimSira value
     * @param int $resimSira
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setResimSira($resimSira = null)
    {
        // validation for constraint: int
        if (!is_null($resimSira) && !(is_int($resimSira) || ctype_digit($resimSira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resimSira, true), gettype($resimSira)), __LINE__);
        }
        $this->ResimSira = $resimSira;
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\Urun360ResimYukleRequest
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Urun360ResimYukleRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
