<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrunResim StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UrunResim
 * @subpackage Structs
 */
class UrunResim extends AbstractStructBase
{
    /**
     * The Resimler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfResim
     */
    public $Resimler;
    /**
     * The UrunID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunID;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * Constructor method for UrunResim
     * @uses UrunResim::setResimler()
     * @uses UrunResim::setUrunID()
     * @uses UrunResim::setUrunKartiID()
     * @param \ArrayType\ArrayOfResim $resimler
     * @param int $urunID
     * @param int $urunKartiID
     */
    public function __construct(\ArrayType\ArrayOfResim $resimler = null, $urunID = null, $urunKartiID = null)
    {
        $this
            ->setResimler($resimler)
            ->setUrunID($urunID)
            ->setUrunKartiID($urunKartiID);
    }
    /**
     * Get Resimler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfResim|null
     */
    public function getResimler()
    {
        return isset($this->Resimler) ? $this->Resimler : null;
    }
    /**
     * Set Resimler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfResim $resimler
     * @return \StructType\UrunResim
     */
    public function setResimler(\ArrayType\ArrayOfResim $resimler = null)
    {
        if (is_null($resimler) || (is_array($resimler) && empty($resimler))) {
            unset($this->Resimler);
        } else {
            $this->Resimler = $resimler;
        }
        return $this;
    }
    /**
     * Get UrunID value
     * @return int|null
     */
    public function getUrunID()
    {
        return $this->UrunID;
    }
    /**
     * Set UrunID value
     * @param int $urunID
     * @return \StructType\UrunResim
     */
    public function setUrunID($urunID = null)
    {
        // validation for constraint: int
        if (!is_null($urunID) && !(is_int($urunID) || ctype_digit($urunID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunID, true), gettype($urunID)), __LINE__);
        }
        $this->UrunID = $urunID;
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\UrunResim
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UrunResim
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
