<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Takim StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Takim
 * @subpackage Structs
 */
class Takim extends AbstractStructBase
{
    /**
     * The KampanyaAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KampanyaAdi;
    /**
     * The KampanyaBaslangic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KampanyaBaslangic;
    /**
     * The KampanyaBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KampanyaBitis;
    /**
     * The TakimUrunleri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTakimUrun
     */
    public $TakimUrunleri;
    /**
     * The TedarikciKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TedarikciKodu;
    /**
     * Constructor method for Takim
     * @uses Takim::setKampanyaAdi()
     * @uses Takim::setKampanyaBaslangic()
     * @uses Takim::setKampanyaBitis()
     * @uses Takim::setTakimUrunleri()
     * @uses Takim::setTedarikciKodu()
     * @param string $kampanyaAdi
     * @param string $kampanyaBaslangic
     * @param string $kampanyaBitis
     * @param \ArrayType\ArrayOfTakimUrun $takimUrunleri
     * @param string $tedarikciKodu
     */
    public function __construct($kampanyaAdi = null, $kampanyaBaslangic = null, $kampanyaBitis = null, \ArrayType\ArrayOfTakimUrun $takimUrunleri = null, $tedarikciKodu = null)
    {
        $this
            ->setKampanyaAdi($kampanyaAdi)
            ->setKampanyaBaslangic($kampanyaBaslangic)
            ->setKampanyaBitis($kampanyaBitis)
            ->setTakimUrunleri($takimUrunleri)
            ->setTedarikciKodu($tedarikciKodu);
    }
    /**
     * Get KampanyaAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKampanyaAdi()
    {
        return isset($this->KampanyaAdi) ? $this->KampanyaAdi : null;
    }
    /**
     * Set KampanyaAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kampanyaAdi
     * @return \StructType\Takim
     */
    public function setKampanyaAdi($kampanyaAdi = null)
    {
        // validation for constraint: string
        if (!is_null($kampanyaAdi) && !is_string($kampanyaAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kampanyaAdi, true), gettype($kampanyaAdi)), __LINE__);
        }
        if (is_null($kampanyaAdi) || (is_array($kampanyaAdi) && empty($kampanyaAdi))) {
            unset($this->KampanyaAdi);
        } else {
            $this->KampanyaAdi = $kampanyaAdi;
        }
        return $this;
    }
    /**
     * Get KampanyaBaslangic value
     * @return string|null
     */
    public function getKampanyaBaslangic()
    {
        return $this->KampanyaBaslangic;
    }
    /**
     * Set KampanyaBaslangic value
     * @param string $kampanyaBaslangic
     * @return \StructType\Takim
     */
    public function setKampanyaBaslangic($kampanyaBaslangic = null)
    {
        // validation for constraint: string
        if (!is_null($kampanyaBaslangic) && !is_string($kampanyaBaslangic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kampanyaBaslangic, true), gettype($kampanyaBaslangic)), __LINE__);
        }
        $this->KampanyaBaslangic = $kampanyaBaslangic;
        return $this;
    }
    /**
     * Get KampanyaBitis value
     * @return string|null
     */
    public function getKampanyaBitis()
    {
        return $this->KampanyaBitis;
    }
    /**
     * Set KampanyaBitis value
     * @param string $kampanyaBitis
     * @return \StructType\Takim
     */
    public function setKampanyaBitis($kampanyaBitis = null)
    {
        // validation for constraint: string
        if (!is_null($kampanyaBitis) && !is_string($kampanyaBitis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kampanyaBitis, true), gettype($kampanyaBitis)), __LINE__);
        }
        $this->KampanyaBitis = $kampanyaBitis;
        return $this;
    }
    /**
     * Get TakimUrunleri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTakimUrun|null
     */
    public function getTakimUrunleri()
    {
        return isset($this->TakimUrunleri) ? $this->TakimUrunleri : null;
    }
    /**
     * Set TakimUrunleri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTakimUrun $takimUrunleri
     * @return \StructType\Takim
     */
    public function setTakimUrunleri(\ArrayType\ArrayOfTakimUrun $takimUrunleri = null)
    {
        if (is_null($takimUrunleri) || (is_array($takimUrunleri) && empty($takimUrunleri))) {
            unset($this->TakimUrunleri);
        } else {
            $this->TakimUrunleri = $takimUrunleri;
        }
        return $this;
    }
    /**
     * Get TedarikciKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTedarikciKodu()
    {
        return isset($this->TedarikciKodu) ? $this->TedarikciKodu : null;
    }
    /**
     * Set TedarikciKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tedarikciKodu
     * @return \StructType\Takim
     */
    public function setTedarikciKodu($tedarikciKodu = null)
    {
        // validation for constraint: string
        if (!is_null($tedarikciKodu) && !is_string($tedarikciKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tedarikciKodu, true), gettype($tedarikciKodu)), __LINE__);
        }
        if (is_null($tedarikciKodu) || (is_array($tedarikciKodu) && empty($tedarikciKodu))) {
            unset($this->TedarikciKodu);
        } else {
            $this->TedarikciKodu = $tedarikciKodu;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Takim
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
