<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Urun ServiceType
 * @subpackage Services
 */
class Urun extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UrunResimYukle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UrunResimYukle $parameters
     * @return \StructType\UrunResimYukleResponse|bool
     */
    public function UrunResimYukle(\StructType\UrunResimYukle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UrunResimYukle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UrunBarkodGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UrunBarkodGuncelle $parameters
     * @return \StructType\UrunBarkodGuncelleResponse|bool
     */
    public function UrunBarkodGuncelle(\StructType\UrunBarkodGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UrunBarkodGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UrunTakimKaydet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UrunTakimKaydet $parameters
     * @return \StructType\UrunTakimKaydetResponse|bool
     */
    public function UrunTakimKaydet(\StructType\UrunTakimKaydet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UrunTakimKaydet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UrunKategoriGuncelleByStokKodu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UrunKategoriGuncelleByStokKodu $parameters
     * @return \StructType\UrunKategoriGuncelleByStokKoduResponse|bool
     */
    public function UrunKategoriGuncelleByStokKodu(\StructType\UrunKategoriGuncelleByStokKodu $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UrunKategoriGuncelleByStokKodu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Urun360ResimYukle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Urun360ResimYukle $parameters
     * @return \StructType\Urun360ResimYukleResponse|bool
     */
    public function Urun360ResimYukle(\StructType\Urun360ResimYukle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Urun360ResimYukle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Urun360ResimYukleResponse|\StructType\UrunBarkodGuncelleResponse|\StructType\UrunKategoriGuncelleByStokKoduResponse|\StructType\UrunResimYukleResponse|\StructType\UrunTakimKaydetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
