<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrunSayfalama StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UrunSayfalama
 * @subpackage Structs
 */
class UrunSayfalama extends AbstractStructBase
{
    /**
     * The BaslangicIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BaslangicIndex;
    /**
     * The KayitSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KayitSayisi;
    /**
     * The SiralamaDegeri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiralamaDegeri;
    /**
     * The SiralamaYonu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiralamaYonu;
    /**
     * Constructor method for UrunSayfalama
     * @uses UrunSayfalama::setBaslangicIndex()
     * @uses UrunSayfalama::setKayitSayisi()
     * @uses UrunSayfalama::setSiralamaDegeri()
     * @uses UrunSayfalama::setSiralamaYonu()
     * @param int $baslangicIndex
     * @param int $kayitSayisi
     * @param string $siralamaDegeri
     * @param string $siralamaYonu
     */
    public function __construct($baslangicIndex = null, $kayitSayisi = null, $siralamaDegeri = null, $siralamaYonu = null)
    {
        $this
            ->setBaslangicIndex($baslangicIndex)
            ->setKayitSayisi($kayitSayisi)
            ->setSiralamaDegeri($siralamaDegeri)
            ->setSiralamaYonu($siralamaYonu);
    }
    /**
     * Get BaslangicIndex value
     * @return int|null
     */
    public function getBaslangicIndex()
    {
        return $this->BaslangicIndex;
    }
    /**
     * Set BaslangicIndex value
     * @param int $baslangicIndex
     * @return \StructType\UrunSayfalama
     */
    public function setBaslangicIndex($baslangicIndex = null)
    {
        // validation for constraint: int
        if (!is_null($baslangicIndex) && !(is_int($baslangicIndex) || ctype_digit($baslangicIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baslangicIndex, true), gettype($baslangicIndex)), __LINE__);
        }
        $this->BaslangicIndex = $baslangicIndex;
        return $this;
    }
    /**
     * Get KayitSayisi value
     * @return int|null
     */
    public function getKayitSayisi()
    {
        return $this->KayitSayisi;
    }
    /**
     * Set KayitSayisi value
     * @param int $kayitSayisi
     * @return \StructType\UrunSayfalama
     */
    public function setKayitSayisi($kayitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kayitSayisi) && !(is_int($kayitSayisi) || ctype_digit($kayitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kayitSayisi, true), gettype($kayitSayisi)), __LINE__);
        }
        $this->KayitSayisi = $kayitSayisi;
        return $this;
    }
    /**
     * Get SiralamaDegeri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiralamaDegeri()
    {
        return isset($this->SiralamaDegeri) ? $this->SiralamaDegeri : null;
    }
    /**
     * Set SiralamaDegeri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siralamaDegeri
     * @return \StructType\UrunSayfalama
     */
    public function setSiralamaDegeri($siralamaDegeri = null)
    {
        // validation for constraint: string
        if (!is_null($siralamaDegeri) && !is_string($siralamaDegeri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siralamaDegeri, true), gettype($siralamaDegeri)), __LINE__);
        }
        if (is_null($siralamaDegeri) || (is_array($siralamaDegeri) && empty($siralamaDegeri))) {
            unset($this->SiralamaDegeri);
        } else {
            $this->SiralamaDegeri = $siralamaDegeri;
        }
        return $this;
    }
    /**
     * Get SiralamaYonu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiralamaYonu()
    {
        return isset($this->SiralamaYonu) ? $this->SiralamaYonu : null;
    }
    /**
     * Set SiralamaYonu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siralamaYonu
     * @return \StructType\UrunSayfalama
     */
    public function setSiralamaYonu($siralamaYonu = null)
    {
        // validation for constraint: string
        if (!is_null($siralamaYonu) && !is_string($siralamaYonu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siralamaYonu, true), gettype($siralamaYonu)), __LINE__);
        }
        if (is_null($siralamaYonu) || (is_array($siralamaYonu) && empty($siralamaYonu))) {
            unset($this->SiralamaYonu);
        } else {
            $this->SiralamaYonu = $siralamaYonu;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UrunSayfalama
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
