<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrunResimYukleRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UrunResimYukleRequest
 * @subpackage Structs
 */
class UrunResimYukleRequest extends AbstractStructBase
{
    /**
     * The EslestirmeTipi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EslestirmeTipi;
    /**
     * The ResimAyraci
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:char
     * @var int
     */
    public $ResimAyraci;
    /**
     * The Resimler
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWebUrunResim
     */
    public $Resimler;
    /**
     * Constructor method for UrunResimYukleRequest
     * @uses UrunResimYukleRequest::setEslestirmeTipi()
     * @uses UrunResimYukleRequest::setResimAyraci()
     * @uses UrunResimYukleRequest::setResimler()
     * @param string $eslestirmeTipi
     * @param int $resimAyraci
     * @param \ArrayType\ArrayOfWebUrunResim $resimler
     */
    public function __construct($eslestirmeTipi = null, $resimAyraci = null, \ArrayType\ArrayOfWebUrunResim $resimler = null)
    {
        $this
            ->setEslestirmeTipi($eslestirmeTipi)
            ->setResimAyraci($resimAyraci)
            ->setResimler($resimler);
    }
    /**
     * Get EslestirmeTipi value
     * @return string|null
     */
    public function getEslestirmeTipi()
    {
        return $this->EslestirmeTipi;
    }
    /**
     * Set EslestirmeTipi value
     * @uses \EnumType\WebUrunResimEslestirmeTipi::valueIsValid()
     * @uses \EnumType\WebUrunResimEslestirmeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eslestirmeTipi
     * @return \StructType\UrunResimYukleRequest
     */
    public function setEslestirmeTipi($eslestirmeTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebUrunResimEslestirmeTipi::valueIsValid($eslestirmeTipi)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eslestirmeTipi, implode(', ', \EnumType\WebUrunResimEslestirmeTipi::getValidValues())), __LINE__);
        }
        $this->EslestirmeTipi = $eslestirmeTipi;
        return $this;
    }
    /**
     * Get ResimAyraci value
     * @return int|null
     */
    public function getResimAyraci()
    {
        return $this->ResimAyraci;
    }
    /**
     * Set ResimAyraci value
     * @param int $resimAyraci
     * @return \StructType\UrunResimYukleRequest
     */
    public function setResimAyraci($resimAyraci = null)
    {
        // validation for constraint: int
        if (!is_null($resimAyraci) && !is_numeric($resimAyraci)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($resimAyraci)), __LINE__);
        }
        $this->ResimAyraci = $resimAyraci;
        return $this;
    }
    /**
     * Get Resimler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWebUrunResim|null
     */
    public function getResimler()
    {
        return isset($this->Resimler) ? $this->Resimler : null;
    }
    /**
     * Set Resimler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWebUrunResim $resimler
     * @return \StructType\UrunResimYukleRequest
     */
    public function setResimler(\ArrayType\ArrayOfWebUrunResim $resimler = null)
    {
        if (is_null($resimler) || (is_array($resimler) && empty($resimler))) {
            unset($this->Resimler);
        } else {
            $this->Resimler = $resimler;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UrunResimYukleRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
