<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectUrunEtiket StructType
 * @subpackage Structs
 */
class SelectUrunEtiket extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The EtiketID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EtiketID;
    /**
     * The UrunKartiID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * Constructor method for SelectUrunEtiket
     * @uses SelectUrunEtiket::setUyeKodu()
     * @uses SelectUrunEtiket::setEtiketID()
     * @uses SelectUrunEtiket::setUrunKartiID()
     * @param string $uyeKodu
     * @param int $etiketID
     * @param int $urunKartiID
     */
    public function __construct($uyeKodu = null, $etiketID = null, $urunKartiID = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setEtiketID($etiketID)
            ->setUrunKartiID($urunKartiID);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\SelectUrunEtiket
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get EtiketID value
     * @return int|null
     */
    public function getEtiketID()
    {
        return $this->EtiketID;
    }
    /**
     * Set EtiketID value
     * @param int $etiketID
     * @return \StructType\SelectUrunEtiket
     */
    public function setEtiketID($etiketID = null)
    {
        // validation for constraint: int
        if (!is_null($etiketID) && !is_numeric($etiketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($etiketID)), __LINE__);
        }
        $this->EtiketID = $etiketID;
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\SelectUrunEtiket
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !is_numeric($urunKartiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectUrunEtiket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
