<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Varyasyon ServiceType
 * @subpackage Services
 */
class Varyasyon extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VaryasyonGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VaryasyonGuncelle $parameters
     * @return \StructType\VaryasyonGuncelleResponse|bool
     */
    public function VaryasyonGuncelle(\StructType\VaryasyonGuncelle $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VaryasyonGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VaryasyonGuncelleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
