<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEtiket ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEtiket
 * @subpackage Arrays
 */
class ArrayOfEtiket extends AbstractStructArrayBase
{
    /**
     * The Etiket
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Etiket[]
     */
    public $Etiket;
    /**
     * Constructor method for ArrayOfEtiket
     * @uses ArrayOfEtiket::setEtiket()
     * @param \StructType\Etiket[] $etiket
     */
    public function __construct(array $etiket = array())
    {
        $this
            ->setEtiket($etiket);
    }
    /**
     * Get Etiket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Etiket[]|null
     */
    public function getEtiket()
    {
        return isset($this->Etiket) ? $this->Etiket : null;
    }
    /**
     * Set Etiket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Etiket[] $etiket
     * @return \ArrayType\ArrayOfEtiket
     */
    public function setEtiket(array $etiket = array())
    {
        foreach ($etiket as $arrayOfEtiketEtiketItem) {
            // validation for constraint: itemType
            if (!$arrayOfEtiketEtiketItem instanceof \StructType\Etiket) {
                throw new \InvalidArgumentException(sprintf('The Etiket property can only contain items of \StructType\Etiket, "%s" given', is_object($arrayOfEtiketEtiketItem) ? get_class($arrayOfEtiketEtiketItem) : gettype($arrayOfEtiketEtiketItem)), __LINE__);
            }
        }
        if (is_null($etiket) || (is_array($etiket) && empty($etiket))) {
            unset($this->Etiket);
        } else {
            $this->Etiket = $etiket;
        }
        return $this;
    }
    /**
     * Add item to Etiket value
     * @throws \InvalidArgumentException
     * @param \StructType\Etiket $item
     * @return \ArrayType\ArrayOfEtiket
     */
    public function addToEtiket(\StructType\Etiket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Etiket) {
            throw new \InvalidArgumentException(sprintf('The Etiket property can only contain items of \StructType\Etiket, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Etiket[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Etiket|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Etiket|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Etiket|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Etiket|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Etiket|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Etiket
     */
    public function getAttributeName()
    {
        return 'Etiket';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEtiket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
