<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tedarikci StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Tedarikci
 * @subpackage Structs
 */
class Tedarikci extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktif;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Mail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mail;
    /**
     * The Not
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Not;
    /**
     * The Tanim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * Constructor method for Tedarikci
     * @uses Tedarikci::setAktif()
     * @uses Tedarikci::setID()
     * @uses Tedarikci::setMail()
     * @uses Tedarikci::setNot()
     * @uses Tedarikci::setTanim()
     * @param bool $aktif
     * @param int $iD
     * @param string $mail
     * @param string $not
     * @param string $tanim
     */
    public function __construct($aktif = null, $iD = null, $mail = null, $not = null, $tanim = null)
    {
        $this
            ->setAktif($aktif)
            ->setID($iD)
            ->setMail($mail)
            ->setNot($not)
            ->setTanim($tanim);
    }
    /**
     * Get Aktif value
     * @return bool|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \StructType\Tedarikci
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Tedarikci
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Mail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMail()
    {
        return isset($this->Mail) ? $this->Mail : null;
    }
    /**
     * Set Mail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mail
     * @return \StructType\Tedarikci
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mail)), __LINE__);
        }
        if (is_null($mail) || (is_array($mail) && empty($mail))) {
            unset($this->Mail);
        } else {
            $this->Mail = $mail;
        }
        return $this;
    }
    /**
     * Get Not value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNot()
    {
        return isset($this->Not) ? $this->Not : null;
    }
    /**
     * Set Not value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $not
     * @return \StructType\Tedarikci
     */
    public function setNot($not = null)
    {
        // validation for constraint: string
        if (!is_null($not) && !is_string($not)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($not)), __LINE__);
        }
        if (is_null($not) || (is_array($not) && empty($not))) {
            unset($this->Not);
        } else {
            $this->Not = $not;
        }
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\Tedarikci
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tedarikci
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
