<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKategori $parameters
     * @return \StructType\SaveKategoriResponse|bool
     */
    public function SaveKategori(\StructType\SaveKategori $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveKategoriParent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKategoriParent $parameters
     * @return \StructType\SaveKategoriParentResponse|bool
     */
    public function SaveKategoriParent(\StructType\SaveKategoriParent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveKategoriParent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMarka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMarka $parameters
     * @return \StructType\SaveMarkaResponse|bool
     */
    public function SaveMarka(\StructType\SaveMarka $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveMarka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTedarikci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTedarikci $parameters
     * @return \StructType\SaveTedarikciResponse|bool
     */
    public function SaveTedarikci(\StructType\SaveTedarikci $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveTedarikci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveEtiket $parameters
     * @return \StructType\SaveEtiketResponse|bool
     */
    public function SaveEtiket(\StructType\SaveEtiket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveParaBirimi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveParaBirimi $parameters
     * @return \StructType\SaveParaBirimiResponse|bool
     */
    public function SaveParaBirimi(\StructType\SaveParaBirimi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveParaBirimi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTeknikDetayGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTeknikDetayGrup $parameters
     * @return \StructType\SaveTeknikDetayGrupResponse|bool
     */
    public function SaveTeknikDetayGrup(\StructType\SaveTeknikDetayGrup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveTeknikDetayGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTeknikDetayOzellik
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTeknikDetayOzellik $parameters
     * @return \StructType\SaveTeknikDetayOzellikResponse|bool
     */
    public function SaveTeknikDetayOzellik(\StructType\SaveTeknikDetayOzellik $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveTeknikDetayOzellik($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTeknikDetayDeger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTeknikDetayDeger $parameters
     * @return \StructType\SaveTeknikDetayDegerResponse|bool
     */
    public function SaveTeknikDetayDeger(\StructType\SaveTeknikDetayDeger $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveTeknikDetayDeger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAsortiGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveAsortiGrup $parameters
     * @return \StructType\SaveAsortiGrupResponse|bool
     */
    public function SaveAsortiGrup(\StructType\SaveAsortiGrup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveAsortiGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAsortiMiktar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveAsortiMiktar $parameters
     * @return \StructType\SaveAsortiMiktarResponse|bool
     */
    public function SaveAsortiMiktar(\StructType\SaveAsortiMiktar $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveAsortiMiktar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrun $parameters
     * @return \StructType\SaveUrunResponse|bool
     */
    public function SaveUrun(\StructType\SaveUrun $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveResim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveResim $parameters
     * @return \StructType\SaveResimResponse|bool
     */
    public function SaveResim(\StructType\SaveResim $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveResim($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMagazaStok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMagazaStok $parameters
     * @return \StructType\SaveMagazaStokResponse|bool
     */
    public function SaveMagazaStok(\StructType\SaveMagazaStok $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveMagazaStok($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrunKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrunKategori $parameters
     * @return \StructType\SaveUrunKategoriResponse|bool
     */
    public function SaveUrunKategori(\StructType\SaveUrunKategori $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveUrunKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrunEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrunEtiket $parameters
     * @return \StructType\SaveUrunEtiketResponse|bool
     */
    public function SaveUrunEtiket(\StructType\SaveUrunEtiket $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveUrunEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveIlgiliUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveIlgiliUrun $parameters
     * @return \StructType\SaveIlgiliUrunResponse|bool
     */
    public function SaveIlgiliUrun(\StructType\SaveIlgiliUrun $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveIlgiliUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveAsortiGrupResponse|\StructType\SaveAsortiMiktarResponse|\StructType\SaveEtiketResponse|\StructType\SaveIlgiliUrunResponse|\StructType\SaveKategoriParentResponse|\StructType\SaveKategoriResponse|\StructType\SaveMagazaStokResponse|\StructType\SaveMarkaResponse|\StructType\SaveParaBirimiResponse|\StructType\SaveResimResponse|\StructType\SaveTedarikciResponse|\StructType\SaveTeknikDetayDegerResponse|\StructType\SaveTeknikDetayGrupResponse|\StructType\SaveTeknikDetayOzellikResponse|\StructType\SaveUrunEtiketResponse|\StructType\SaveUrunKategoriResponse|\StructType\SaveUrunResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
