<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkVatApprox StructType
 * @subpackage Structs
 */
class CheckVatApprox extends AbstractStructBase
{
    /**
     * The countryCode
     * @var string
     */
    public $countryCode;
    /**
     * The vatNumber
     * @var string
     */
    public $vatNumber;
    /**
     * The traderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderName;
    /**
     * The traderCompanyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}\-[1-9][0-9]?
     * @var string
     */
    public $traderCompanyType;
    /**
     * The traderStreet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderStreet;
    /**
     * The traderPostcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderPostcode;
    /**
     * The traderCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $traderCity;
    /**
     * The requesterCountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requesterCountryCode;
    /**
     * The requesterVatNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requesterVatNumber;
    /**
     * Constructor method for checkVatApprox
     * @uses CheckVatApprox::setCountryCode()
     * @uses CheckVatApprox::setVatNumber()
     * @uses CheckVatApprox::setTraderName()
     * @uses CheckVatApprox::setTraderCompanyType()
     * @uses CheckVatApprox::setTraderStreet()
     * @uses CheckVatApprox::setTraderPostcode()
     * @uses CheckVatApprox::setTraderCity()
     * @uses CheckVatApprox::setRequesterCountryCode()
     * @uses CheckVatApprox::setRequesterVatNumber()
     * @param string $countryCode
     * @param string $vatNumber
     * @param string $traderName
     * @param string $traderCompanyType
     * @param string $traderStreet
     * @param string $traderPostcode
     * @param string $traderCity
     * @param string $requesterCountryCode
     * @param string $requesterVatNumber
     */
    public function __construct($countryCode = null, $vatNumber = null, $traderName = null, $traderCompanyType = null, $traderStreet = null, $traderPostcode = null, $traderCity = null, $requesterCountryCode = null, $requesterVatNumber = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setVatNumber($vatNumber)
            ->setTraderName($traderName)
            ->setTraderCompanyType($traderCompanyType)
            ->setTraderStreet($traderStreet)
            ->setTraderPostcode($traderPostcode)
            ->setTraderCity($traderCity)
            ->setRequesterCountryCode($requesterCountryCode)
            ->setRequesterVatNumber($requesterVatNumber);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\CheckVatApprox
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get vatNumber value
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->vatNumber;
    }
    /**
     * Set vatNumber value
     * @param string $vatNumber
     * @return \StructType\CheckVatApprox
     */
    public function setVatNumber($vatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatNumber) && !is_string($vatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatNumber)), __LINE__);
        }
        $this->vatNumber = $vatNumber;
        return $this;
    }
    /**
     * Get traderName value
     * @return string|null
     */
    public function getTraderName()
    {
        return $this->traderName;
    }
    /**
     * Set traderName value
     * @param string $traderName
     * @return \StructType\CheckVatApprox
     */
    public function setTraderName($traderName = null)
    {
        // validation for constraint: string
        if (!is_null($traderName) && !is_string($traderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traderName)), __LINE__);
        }
        $this->traderName = $traderName;
        return $this;
    }
    /**
     * Get traderCompanyType value
     * @return string|null
     */
    public function getTraderCompanyType()
    {
        return $this->traderCompanyType;
    }
    /**
     * Set traderCompanyType value
     * @param string $traderCompanyType
     * @return \StructType\CheckVatApprox
     */
    public function setTraderCompanyType($traderCompanyType = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traderCompanyType) && !preg_match('/[A-Z]{2}\\-[1-9][0-9]?/', $traderCompanyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]{2}\-[1-9][0-9]?", "%s" given', var_export($traderCompanyType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traderCompanyType) && !is_string($traderCompanyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traderCompanyType)), __LINE__);
        }
        $this->traderCompanyType = $traderCompanyType;
        return $this;
    }
    /**
     * Get traderStreet value
     * @return string|null
     */
    public function getTraderStreet()
    {
        return $this->traderStreet;
    }
    /**
     * Set traderStreet value
     * @param string $traderStreet
     * @return \StructType\CheckVatApprox
     */
    public function setTraderStreet($traderStreet = null)
    {
        // validation for constraint: string
        if (!is_null($traderStreet) && !is_string($traderStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traderStreet)), __LINE__);
        }
        $this->traderStreet = $traderStreet;
        return $this;
    }
    /**
     * Get traderPostcode value
     * @return string|null
     */
    public function getTraderPostcode()
    {
        return $this->traderPostcode;
    }
    /**
     * Set traderPostcode value
     * @param string $traderPostcode
     * @return \StructType\CheckVatApprox
     */
    public function setTraderPostcode($traderPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($traderPostcode) && !is_string($traderPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traderPostcode)), __LINE__);
        }
        $this->traderPostcode = $traderPostcode;
        return $this;
    }
    /**
     * Get traderCity value
     * @return string|null
     */
    public function getTraderCity()
    {
        return $this->traderCity;
    }
    /**
     * Set traderCity value
     * @param string $traderCity
     * @return \StructType\CheckVatApprox
     */
    public function setTraderCity($traderCity = null)
    {
        // validation for constraint: string
        if (!is_null($traderCity) && !is_string($traderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traderCity)), __LINE__);
        }
        $this->traderCity = $traderCity;
        return $this;
    }
    /**
     * Get requesterCountryCode value
     * @return string|null
     */
    public function getRequesterCountryCode()
    {
        return $this->requesterCountryCode;
    }
    /**
     * Set requesterCountryCode value
     * @param string $requesterCountryCode
     * @return \StructType\CheckVatApprox
     */
    public function setRequesterCountryCode($requesterCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($requesterCountryCode) && !is_string($requesterCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requesterCountryCode)), __LINE__);
        }
        $this->requesterCountryCode = $requesterCountryCode;
        return $this;
    }
    /**
     * Get requesterVatNumber value
     * @return string|null
     */
    public function getRequesterVatNumber()
    {
        return $this->requesterVatNumber;
    }
    /**
     * Set requesterVatNumber value
     * @param string $requesterVatNumber
     * @return \StructType\CheckVatApprox
     */
    public function setRequesterVatNumber($requesterVatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($requesterVatNumber) && !is_string($requesterVatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requesterVatNumber)), __LINE__);
        }
        $this->requesterVatNumber = $requesterVatNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckVatApprox
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
