<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseDetails StructType
 * @subpackage Structs
 */
class WarehouseDetails extends AbstractStructBase
{
    /**
     * The StockItemWarehouseDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StockItemWarehouseDetail[]
     */
    public $StockItemWarehouseDetail;
    /**
     * Constructor method for WarehouseDetails
     * @uses WarehouseDetails::setStockItemWarehouseDetail()
     * @param \StructType\StockItemWarehouseDetail[] $stockItemWarehouseDetail
     */
    public function __construct(array $stockItemWarehouseDetail = array())
    {
        $this
            ->setStockItemWarehouseDetail($stockItemWarehouseDetail);
    }
    /**
     * Get StockItemWarehouseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StockItemWarehouseDetail[]|null
     */
    public function getStockItemWarehouseDetail()
    {
        return isset($this->StockItemWarehouseDetail) ? $this->StockItemWarehouseDetail : null;
    }
    /**
     * Set StockItemWarehouseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemWarehouseDetail[] $stockItemWarehouseDetail
     * @return \StructType\WarehouseDetails
     */
    public function setStockItemWarehouseDetail(array $stockItemWarehouseDetail = array())
    {
        foreach ($stockItemWarehouseDetail as $warehouseDetailsStockItemWarehouseDetailItem) {
            // validation for constraint: itemType
            if (!$warehouseDetailsStockItemWarehouseDetailItem instanceof \StructType\StockItemWarehouseDetail) {
                throw new \InvalidArgumentException(sprintf('The StockItemWarehouseDetail property can only contain items of \StructType\StockItemWarehouseDetail, "%s" given', is_object($warehouseDetailsStockItemWarehouseDetailItem) ? get_class($warehouseDetailsStockItemWarehouseDetailItem) : gettype($warehouseDetailsStockItemWarehouseDetailItem)), __LINE__);
            }
        }
        if (is_null($stockItemWarehouseDetail) || (is_array($stockItemWarehouseDetail) && empty($stockItemWarehouseDetail))) {
            unset($this->StockItemWarehouseDetail);
        } else {
            $this->StockItemWarehouseDetail = $stockItemWarehouseDetail;
        }
        return $this;
    }
    /**
     * Add item to StockItemWarehouseDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemWarehouseDetail $item
     * @return \StructType\WarehouseDetails
     */
    public function addToStockItemWarehouseDetail(\StructType\StockItemWarehouseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemWarehouseDetail) {
            throw new \InvalidArgumentException(sprintf('The StockItemWarehouseDetail property can only contain items of \StructType\StockItemWarehouseDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StockItemWarehouseDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarehouseDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
