<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Values StructType
 * @subpackage Structs
 */
class Values extends AbstractStructBase
{
    /**
     * The AttributeDefinitionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AttributeDefinitionValue[]
     */
    public $AttributeDefinitionValue;
    /**
     * Constructor method for Values
     * @uses Values::setAttributeDefinitionValue()
     * @param \StructType\AttributeDefinitionValue[] $attributeDefinitionValue
     */
    public function __construct(array $attributeDefinitionValue = array())
    {
        $this
            ->setAttributeDefinitionValue($attributeDefinitionValue);
    }
    /**
     * Get AttributeDefinitionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AttributeDefinitionValue[]|null
     */
    public function getAttributeDefinitionValue()
    {
        return isset($this->AttributeDefinitionValue) ? $this->AttributeDefinitionValue : null;
    }
    /**
     * Set AttributeDefinitionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeDefinitionValue[] $attributeDefinitionValue
     * @return \StructType\Values
     */
    public function setAttributeDefinitionValue(array $attributeDefinitionValue = array())
    {
        foreach ($attributeDefinitionValue as $valuesAttributeDefinitionValueItem) {
            // validation for constraint: itemType
            if (!$valuesAttributeDefinitionValueItem instanceof \StructType\AttributeDefinitionValue) {
                throw new \InvalidArgumentException(sprintf('The AttributeDefinitionValue property can only contain items of \StructType\AttributeDefinitionValue, "%s" given', is_object($valuesAttributeDefinitionValueItem) ? get_class($valuesAttributeDefinitionValueItem) : gettype($valuesAttributeDefinitionValueItem)), __LINE__);
            }
        }
        if (is_null($attributeDefinitionValue) || (is_array($attributeDefinitionValue) && empty($attributeDefinitionValue))) {
            unset($this->AttributeDefinitionValue);
        } else {
            $this->AttributeDefinitionValue = $attributeDefinitionValue;
        }
        return $this;
    }
    /**
     * Add item to AttributeDefinitionValue value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributeDefinitionValue $item
     * @return \StructType\Values
     */
    public function addToAttributeDefinitionValue(\StructType\AttributeDefinitionValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributeDefinitionValue) {
            throw new \InvalidArgumentException(sprintf('The AttributeDefinitionValue property can only contain items of \StructType\AttributeDefinitionValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttributeDefinitionValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Values
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
