<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UOMConversions StructType
 * @subpackage Structs
 */
class UOMConversions extends AbstractStructBase
{
    /**
     * The InventoryItemUOMConversion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InventoryItemUOMConversion[]
     */
    public $InventoryItemUOMConversion;
    /**
     * Constructor method for UOMConversions
     * @uses UOMConversions::setInventoryItemUOMConversion()
     * @param \StructType\InventoryItemUOMConversion[] $inventoryItemUOMConversion
     */
    public function __construct(array $inventoryItemUOMConversion = array())
    {
        $this
            ->setInventoryItemUOMConversion($inventoryItemUOMConversion);
    }
    /**
     * Get InventoryItemUOMConversion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InventoryItemUOMConversion[]|null
     */
    public function getInventoryItemUOMConversion()
    {
        return isset($this->InventoryItemUOMConversion) ? $this->InventoryItemUOMConversion : null;
    }
    /**
     * Set InventoryItemUOMConversion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemUOMConversion[] $inventoryItemUOMConversion
     * @return \StructType\UOMConversions
     */
    public function setInventoryItemUOMConversion(array $inventoryItemUOMConversion = array())
    {
        foreach ($inventoryItemUOMConversion as $uOMConversionsInventoryItemUOMConversionItem) {
            // validation for constraint: itemType
            if (!$uOMConversionsInventoryItemUOMConversionItem instanceof \StructType\InventoryItemUOMConversion) {
                throw new \InvalidArgumentException(sprintf('The InventoryItemUOMConversion property can only contain items of \StructType\InventoryItemUOMConversion, "%s" given', is_object($uOMConversionsInventoryItemUOMConversionItem) ? get_class($uOMConversionsInventoryItemUOMConversionItem) : gettype($uOMConversionsInventoryItemUOMConversionItem)), __LINE__);
            }
        }
        if (is_null($inventoryItemUOMConversion) || (is_array($inventoryItemUOMConversion) && empty($inventoryItemUOMConversion))) {
            unset($this->InventoryItemUOMConversion);
        } else {
            $this->InventoryItemUOMConversion = $inventoryItemUOMConversion;
        }
        return $this;
    }
    /**
     * Add item to InventoryItemUOMConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryItemUOMConversion $item
     * @return \StructType\UOMConversions
     */
    public function addToInventoryItemUOMConversion(\StructType\InventoryItemUOMConversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryItemUOMConversion) {
            throw new \InvalidArgumentException(sprintf('The InventoryItemUOMConversion property can only contain items of \StructType\InventoryItemUOMConversion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryItemUOMConversion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UOMConversions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
