<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferOrderDetailAllocation StructType
 * @subpackage Structs
 */
class TransferOrderDetailAllocation extends Entity
{
    /**
     * The LocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The LotSerialNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LotSerialNbr;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Quantity;
    /**
     * Constructor method for TransferOrderDetailAllocation
     * @uses TransferOrderDetailAllocation::setLocationID()
     * @uses TransferOrderDetailAllocation::setLotSerialNbr()
     * @uses TransferOrderDetailAllocation::setQuantity()
     * @param \StructType\StringValue $locationID
     * @param \StructType\StringValue $lotSerialNbr
     * @param \StructType\DecimalValue $quantity
     */
    public function __construct(\StructType\StringValue $locationID = null, \StructType\StringValue $lotSerialNbr = null, \StructType\DecimalValue $quantity = null)
    {
        $this
            ->setLocationID($locationID)
            ->setLotSerialNbr($lotSerialNbr)
            ->setQuantity($quantity);
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\TransferOrderDetailAllocation
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLotSerialNbr()
    {
        return isset($this->LotSerialNbr) ? $this->LotSerialNbr : null;
    }
    /**
     * Set LotSerialNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $lotSerialNbr
     * @return \StructType\TransferOrderDetailAllocation
     */
    public function setLotSerialNbr(\StructType\StringValue $lotSerialNbr = null)
    {
        if (is_null($lotSerialNbr) || (is_array($lotSerialNbr) && empty($lotSerialNbr))) {
            unset($this->LotSerialNbr);
        } else {
            $this->LotSerialNbr = $lotSerialNbr;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $quantity
     * @return \StructType\TransferOrderDetailAllocation
     */
    public function setQuantity(\StructType\DecimalValue $quantity = null)
    {
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferOrderDetailAllocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
