<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemWarehouseDetail StructType
 * @subpackage Structs
 */
class StockItemWarehouseDetail extends Entity
{
    /**
     * The DefaultIssueLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DefaultIssueLocationID;
    /**
     * The DefaultReceiptLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DefaultReceiptLocationID;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IsDefault;
    /**
     * The QtyOnHand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $QtyOnHand;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for StockItemWarehouseDetail
     * @uses StockItemWarehouseDetail::setDefaultIssueLocationID()
     * @uses StockItemWarehouseDetail::setDefaultReceiptLocationID()
     * @uses StockItemWarehouseDetail::setIsDefault()
     * @uses StockItemWarehouseDetail::setQtyOnHand()
     * @uses StockItemWarehouseDetail::setWarehouseID()
     * @param \StructType\StringValue $defaultIssueLocationID
     * @param \StructType\StringValue $defaultReceiptLocationID
     * @param \StructType\BooleanValue $isDefault
     * @param \StructType\DecimalValue $qtyOnHand
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\StringValue $defaultIssueLocationID = null, \StructType\StringValue $defaultReceiptLocationID = null, \StructType\BooleanValue $isDefault = null, \StructType\DecimalValue $qtyOnHand = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setDefaultIssueLocationID($defaultIssueLocationID)
            ->setDefaultReceiptLocationID($defaultReceiptLocationID)
            ->setIsDefault($isDefault)
            ->setQtyOnHand($qtyOnHand)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get DefaultIssueLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDefaultIssueLocationID()
    {
        return isset($this->DefaultIssueLocationID) ? $this->DefaultIssueLocationID : null;
    }
    /**
     * Set DefaultIssueLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $defaultIssueLocationID
     * @return \StructType\StockItemWarehouseDetail
     */
    public function setDefaultIssueLocationID(\StructType\StringValue $defaultIssueLocationID = null)
    {
        if (is_null($defaultIssueLocationID) || (is_array($defaultIssueLocationID) && empty($defaultIssueLocationID))) {
            unset($this->DefaultIssueLocationID);
        } else {
            $this->DefaultIssueLocationID = $defaultIssueLocationID;
        }
        return $this;
    }
    /**
     * Get DefaultReceiptLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDefaultReceiptLocationID()
    {
        return isset($this->DefaultReceiptLocationID) ? $this->DefaultReceiptLocationID : null;
    }
    /**
     * Set DefaultReceiptLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $defaultReceiptLocationID
     * @return \StructType\StockItemWarehouseDetail
     */
    public function setDefaultReceiptLocationID(\StructType\StringValue $defaultReceiptLocationID = null)
    {
        if (is_null($defaultReceiptLocationID) || (is_array($defaultReceiptLocationID) && empty($defaultReceiptLocationID))) {
            unset($this->DefaultReceiptLocationID);
        } else {
            $this->DefaultReceiptLocationID = $defaultReceiptLocationID;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $isDefault
     * @return \StructType\StockItemWarehouseDetail
     */
    public function setIsDefault(\StructType\BooleanValue $isDefault = null)
    {
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get QtyOnHand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQtyOnHand()
    {
        return isset($this->QtyOnHand) ? $this->QtyOnHand : null;
    }
    /**
     * Set QtyOnHand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qtyOnHand
     * @return \StructType\StockItemWarehouseDetail
     */
    public function setQtyOnHand(\StructType\DecimalValue $qtyOnHand = null)
    {
        if (is_null($qtyOnHand) || (is_array($qtyOnHand) && empty($qtyOnHand))) {
            unset($this->QtyOnHand);
        } else {
            $this->QtyOnHand = $qtyOnHand;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\StockItemWarehouseDetail
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemWarehouseDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
